/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DatasetMetadata;
import com.amazonaws.services.quicksight.model.TopicUserExperienceVersion;
import com.amazonaws.services.quicksight.model.transform.TopicDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String userExperienceVersion;
    private List<DatasetMetadata> dataSets;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TopicDetails withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TopicDetails withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setUserExperienceVersion(String userExperienceVersion) {
        this.userExperienceVersion = userExperienceVersion;
    }

    public String getUserExperienceVersion() {
        return this.userExperienceVersion;
    }

    public TopicDetails withUserExperienceVersion(String userExperienceVersion) {
        this.setUserExperienceVersion(userExperienceVersion);
        return this;
    }

    public TopicDetails withUserExperienceVersion(TopicUserExperienceVersion userExperienceVersion) {
        this.userExperienceVersion = userExperienceVersion.toString();
        return this;
    }

    public List<DatasetMetadata> getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(Collection<DatasetMetadata> dataSets) {
        if (dataSets == null) {
            this.dataSets = null;
            return;
        }
        this.dataSets = new ArrayList<DatasetMetadata>(dataSets);
    }

    public TopicDetails withDataSets(DatasetMetadata ... dataSets) {
        if (this.dataSets == null) {
            this.setDataSets(new ArrayList<DatasetMetadata>(dataSets.length));
        }
        for (DatasetMetadata ele : dataSets) {
            this.dataSets.add(ele);
        }
        return this;
    }

    public TopicDetails withDataSets(Collection<DatasetMetadata> dataSets) {
        this.setDataSets(dataSets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getUserExperienceVersion() != null) {
            sb.append("UserExperienceVersion: ").append(this.getUserExperienceVersion()).append(",");
        }
        if (this.getDataSets() != null) {
            sb.append("DataSets: ").append(this.getDataSets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicDetails)) {
            return false;
        }
        TopicDetails other = (TopicDetails)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getUserExperienceVersion() == null ^ this.getUserExperienceVersion() == null) {
            return false;
        }
        if (other.getUserExperienceVersion() != null && !other.getUserExperienceVersion().equals(this.getUserExperienceVersion())) {
            return false;
        }
        if (other.getDataSets() == null ^ this.getDataSets() == null) {
            return false;
        }
        return other.getDataSets() == null || other.getDataSets().equals(this.getDataSets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getUserExperienceVersion() == null ? 0 : this.getUserExperienceVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDataSets() == null ? 0 : this.getDataSets().hashCode());
        return hashCode;
    }

    public TopicDetails clone() {
        try {
            return (TopicDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

