/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Computation;
import com.amazonaws.services.quicksight.model.CustomNarrativeOptions;
import com.amazonaws.services.quicksight.model.VisualInteractionOptions;
import com.amazonaws.services.quicksight.model.transform.InsightConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InsightConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Computation> computations;
    private CustomNarrativeOptions customNarrative;
    private VisualInteractionOptions interactions;

    public List<Computation> getComputations() {
        return this.computations;
    }

    public void setComputations(Collection<Computation> computations) {
        if (computations == null) {
            this.computations = null;
            return;
        }
        this.computations = new ArrayList<Computation>(computations);
    }

    public InsightConfiguration withComputations(Computation ... computations) {
        if (this.computations == null) {
            this.setComputations(new ArrayList<Computation>(computations.length));
        }
        for (Computation ele : computations) {
            this.computations.add(ele);
        }
        return this;
    }

    public InsightConfiguration withComputations(Collection<Computation> computations) {
        this.setComputations(computations);
        return this;
    }

    public void setCustomNarrative(CustomNarrativeOptions customNarrative) {
        this.customNarrative = customNarrative;
    }

    public CustomNarrativeOptions getCustomNarrative() {
        return this.customNarrative;
    }

    public InsightConfiguration withCustomNarrative(CustomNarrativeOptions customNarrative) {
        this.setCustomNarrative(customNarrative);
        return this;
    }

    public void setInteractions(VisualInteractionOptions interactions) {
        this.interactions = interactions;
    }

    public VisualInteractionOptions getInteractions() {
        return this.interactions;
    }

    public InsightConfiguration withInteractions(VisualInteractionOptions interactions) {
        this.setInteractions(interactions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComputations() != null) {
            sb.append("Computations: ").append(this.getComputations()).append(",");
        }
        if (this.getCustomNarrative() != null) {
            sb.append("CustomNarrative: ").append(this.getCustomNarrative()).append(",");
        }
        if (this.getInteractions() != null) {
            sb.append("Interactions: ").append(this.getInteractions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightConfiguration)) {
            return false;
        }
        InsightConfiguration other = (InsightConfiguration)obj;
        if (other.getComputations() == null ^ this.getComputations() == null) {
            return false;
        }
        if (other.getComputations() != null && !other.getComputations().equals(this.getComputations())) {
            return false;
        }
        if (other.getCustomNarrative() == null ^ this.getCustomNarrative() == null) {
            return false;
        }
        if (other.getCustomNarrative() != null && !other.getCustomNarrative().equals(this.getCustomNarrative())) {
            return false;
        }
        if (other.getInteractions() == null ^ this.getInteractions() == null) {
            return false;
        }
        return other.getInteractions() == null || other.getInteractions().equals(this.getInteractions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComputations() == null ? 0 : this.getComputations().hashCode());
        hashCode = 31 * hashCode + (this.getCustomNarrative() == null ? 0 : this.getCustomNarrative().hashCode());
        hashCode = 31 * hashCode + (this.getInteractions() == null ? 0 : this.getInteractions().hashCode());
        return hashCode;
    }

    public InsightConfiguration clone() {
        try {
            return (InsightConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

