/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.GeospatialCoordinateBounds;
import com.amazonaws.services.quicksight.model.MapZoomMode;
import com.amazonaws.services.quicksight.model.transform.GeospatialWindowOptionsMarshaller;
import java.io.Serializable;

public class GeospatialWindowOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private GeospatialCoordinateBounds bounds;
    private String mapZoomMode;

    public void setBounds(GeospatialCoordinateBounds bounds) {
        this.bounds = bounds;
    }

    public GeospatialCoordinateBounds getBounds() {
        return this.bounds;
    }

    public GeospatialWindowOptions withBounds(GeospatialCoordinateBounds bounds) {
        this.setBounds(bounds);
        return this;
    }

    public void setMapZoomMode(String mapZoomMode) {
        this.mapZoomMode = mapZoomMode;
    }

    public String getMapZoomMode() {
        return this.mapZoomMode;
    }

    public GeospatialWindowOptions withMapZoomMode(String mapZoomMode) {
        this.setMapZoomMode(mapZoomMode);
        return this;
    }

    public GeospatialWindowOptions withMapZoomMode(MapZoomMode mapZoomMode) {
        this.mapZoomMode = mapZoomMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBounds() != null) {
            sb.append("Bounds: ").append(this.getBounds()).append(",");
        }
        if (this.getMapZoomMode() != null) {
            sb.append("MapZoomMode: ").append(this.getMapZoomMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialWindowOptions)) {
            return false;
        }
        GeospatialWindowOptions other = (GeospatialWindowOptions)obj;
        if (other.getBounds() == null ^ this.getBounds() == null) {
            return false;
        }
        if (other.getBounds() != null && !other.getBounds().equals(this.getBounds())) {
            return false;
        }
        if (other.getMapZoomMode() == null ^ this.getMapZoomMode() == null) {
            return false;
        }
        return other.getMapZoomMode() == null || other.getMapZoomMode().equals(this.getMapZoomMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBounds() == null ? 0 : this.getBounds().hashCode());
        hashCode = 31 * hashCode + (this.getMapZoomMode() == null ? 0 : this.getMapZoomMode().hashCode());
        return hashCode;
    }

    public GeospatialWindowOptions clone() {
        try {
            return (GeospatialWindowOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeospatialWindowOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

