/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.quicksight.model.ResourcePermission;
import com.amazonaws.services.quicksight.model.Tag;
import com.amazonaws.services.quicksight.model.TemplateSourceEntity;
import com.amazonaws.services.quicksight.model.TemplateVersionDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTemplateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String awsAccountId;
    private String templateId;
    private String name;
    private List<ResourcePermission> permissions;
    private TemplateSourceEntity sourceEntity;
    private List<Tag> tags;
    private String versionDescription;
    private TemplateVersionDefinition definition;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public CreateTemplateRequest withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public CreateTemplateRequest withTemplateId(String templateId) {
        this.setTemplateId(templateId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTemplateRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<ResourcePermission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<ResourcePermission>(permissions);
    }

    public CreateTemplateRequest withPermissions(ResourcePermission ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<ResourcePermission>(permissions.length));
        }
        for (ResourcePermission ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public CreateTemplateRequest withPermissions(Collection<ResourcePermission> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setSourceEntity(TemplateSourceEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public TemplateSourceEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public CreateTemplateRequest withSourceEntity(TemplateSourceEntity sourceEntity) {
        this.setSourceEntity(sourceEntity);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateTemplateRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateTemplateRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVersionDescription(String versionDescription) {
        this.versionDescription = versionDescription;
    }

    public String getVersionDescription() {
        return this.versionDescription;
    }

    public CreateTemplateRequest withVersionDescription(String versionDescription) {
        this.setVersionDescription(versionDescription);
        return this;
    }

    public void setDefinition(TemplateVersionDefinition definition) {
        this.definition = definition;
    }

    public TemplateVersionDefinition getDefinition() {
        return this.definition;
    }

    public CreateTemplateRequest withDefinition(TemplateVersionDefinition definition) {
        this.setDefinition(definition);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getTemplateId() != null) {
            sb.append("TemplateId: ").append(this.getTemplateId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getSourceEntity() != null) {
            sb.append("SourceEntity: ").append(this.getSourceEntity()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVersionDescription() != null) {
            sb.append("VersionDescription: ").append(this.getVersionDescription()).append(",");
        }
        if (this.getDefinition() != null) {
            sb.append("Definition: ").append(this.getDefinition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getTemplateId() == null ^ this.getTemplateId() == null) {
            return false;
        }
        if (other.getTemplateId() != null && !other.getTemplateId().equals(this.getTemplateId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getSourceEntity() == null ^ this.getSourceEntity() == null) {
            return false;
        }
        if (other.getSourceEntity() != null && !other.getSourceEntity().equals(this.getSourceEntity())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVersionDescription() == null ^ this.getVersionDescription() == null) {
            return false;
        }
        if (other.getVersionDescription() != null && !other.getVersionDescription().equals(this.getVersionDescription())) {
            return false;
        }
        if (other.getDefinition() == null ^ this.getDefinition() == null) {
            return false;
        }
        return other.getDefinition() == null || other.getDefinition().equals(this.getDefinition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateId() == null ? 0 : this.getTemplateId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEntity() == null ? 0 : this.getSourceEntity().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVersionDescription() == null ? 0 : this.getVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDefinition() == null ? 0 : this.getDefinition().hashCode());
        return hashCode;
    }

    public CreateTemplateRequest clone() {
        return (CreateTemplateRequest)super.clone();
    }
}

