/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ColumnIdentifier;
import com.amazonaws.services.quicksight.model.transform.CategoryDrillDownFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CategoryDrillDownFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private ColumnIdentifier column;
    private List<String> categoryValues;

    public void setColumn(ColumnIdentifier column) {
        this.column = column;
    }

    public ColumnIdentifier getColumn() {
        return this.column;
    }

    public CategoryDrillDownFilter withColumn(ColumnIdentifier column) {
        this.setColumn(column);
        return this;
    }

    public List<String> getCategoryValues() {
        return this.categoryValues;
    }

    public void setCategoryValues(Collection<String> categoryValues) {
        if (categoryValues == null) {
            this.categoryValues = null;
            return;
        }
        this.categoryValues = new ArrayList<String>(categoryValues);
    }

    public CategoryDrillDownFilter withCategoryValues(String ... categoryValues) {
        if (this.categoryValues == null) {
            this.setCategoryValues(new ArrayList<String>(categoryValues.length));
        }
        for (String ele : categoryValues) {
            this.categoryValues.add(ele);
        }
        return this;
    }

    public CategoryDrillDownFilter withCategoryValues(Collection<String> categoryValues) {
        this.setCategoryValues(categoryValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumn() != null) {
            sb.append("Column: ").append(this.getColumn()).append(",");
        }
        if (this.getCategoryValues() != null) {
            sb.append("CategoryValues: ").append(this.getCategoryValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryDrillDownFilter)) {
            return false;
        }
        CategoryDrillDownFilter other = (CategoryDrillDownFilter)obj;
        if (other.getColumn() == null ^ this.getColumn() == null) {
            return false;
        }
        if (other.getColumn() != null && !other.getColumn().equals(this.getColumn())) {
            return false;
        }
        if (other.getCategoryValues() == null ^ this.getCategoryValues() == null) {
            return false;
        }
        return other.getCategoryValues() == null || other.getCategoryValues().equals(this.getCategoryValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumn() == null ? 0 : this.getColumn().hashCode());
        hashCode = 31 * hashCode + (this.getCategoryValues() == null ? 0 : this.getCategoryValues().hashCode());
        return hashCode;
    }

    public CategoryDrillDownFilter clone() {
        try {
            return (CategoryDrillDownFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CategoryDrillDownFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

