/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataSourceParameters;
import com.amazonaws.services.quicksight.model.transform.CredentialPairMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CredentialPair
implements Serializable,
Cloneable,
StructuredPojo {
    private String username;
    private String password;
    private List<DataSourceParameters> alternateDataSourceParameters;

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public CredentialPair withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public CredentialPair withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public List<DataSourceParameters> getAlternateDataSourceParameters() {
        return this.alternateDataSourceParameters;
    }

    public void setAlternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
        if (alternateDataSourceParameters == null) {
            this.alternateDataSourceParameters = null;
            return;
        }
        this.alternateDataSourceParameters = new ArrayList<DataSourceParameters>(alternateDataSourceParameters);
    }

    public CredentialPair withAlternateDataSourceParameters(DataSourceParameters ... alternateDataSourceParameters) {
        if (this.alternateDataSourceParameters == null) {
            this.setAlternateDataSourceParameters(new ArrayList<DataSourceParameters>(alternateDataSourceParameters.length));
        }
        for (DataSourceParameters ele : alternateDataSourceParameters) {
            this.alternateDataSourceParameters.add(ele);
        }
        return this;
    }

    public CredentialPair withAlternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
        this.setAlternateDataSourceParameters(alternateDataSourceParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append(this.getPassword()).append(",");
        }
        if (this.getAlternateDataSourceParameters() != null) {
            sb.append("AlternateDataSourceParameters: ").append(this.getAlternateDataSourceParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialPair)) {
            return false;
        }
        CredentialPair other = (CredentialPair)obj;
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getAlternateDataSourceParameters() == null ^ this.getAlternateDataSourceParameters() == null) {
            return false;
        }
        return other.getAlternateDataSourceParameters() == null || other.getAlternateDataSourceParameters().equals(this.getAlternateDataSourceParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getAlternateDataSourceParameters() == null ? 0 : this.getAlternateDataSourceParameters().hashCode());
        return hashCode;
    }

    public CredentialPair clone() {
        try {
            return (CredentialPair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CredentialPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

