/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qbusiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.qbusiness.model.GroupSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListGroupsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<GroupSummary> items;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListGroupsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<GroupSummary> getItems() {
        return this.items;
    }

    public void setItems(Collection<GroupSummary> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<GroupSummary>(items);
    }

    public ListGroupsResult withItems(GroupSummary ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<GroupSummary>(items.length));
        }
        for (GroupSummary ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public ListGroupsResult withItems(Collection<GroupSummary> items) {
        this.setItems(items);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsResult)) {
            return false;
        }
        ListGroupsResult other = (ListGroupsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public ListGroupsResult clone() {
        try {
            return (ListGroupsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

