/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.prometheus.model.transform.EksConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EksConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String clusterArn;
    private List<String> securityGroupIds;
    private List<String> subnetIds;

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public EksConfiguration withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public EksConfiguration withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public EksConfiguration withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public EksConfiguration withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public EksConfiguration withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksConfiguration)) {
            return false;
        }
        EksConfiguration other = (EksConfiguration)obj;
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        return other.getSubnetIds() == null || other.getSubnetIds().equals(this.getSubnetIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        return hashCode;
    }

    public EksConfiguration clone() {
        try {
            return (EksConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EksConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

