/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.prometheus.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.prometheus.model.ScrapeConfiguration;
import java.nio.ByteBuffer;

@SdkInternalApi
public class ScrapeConfigurationMarshaller {
    private static final MarshallingInfo<ByteBuffer> CONFIGURATIONBLOB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationBlob").build();
    private static final ScrapeConfigurationMarshaller instance = new ScrapeConfigurationMarshaller();

    public static ScrapeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ScrapeConfiguration scrapeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (scrapeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scrapeConfiguration.getConfigurationBlob(), CONFIGURATIONBLOB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

