/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pricing.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pricing.model.transform.ServiceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Service
implements Serializable,
Cloneable,
StructuredPojo {
    private String serviceCode;
    private List<String> attributeNames;

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public Service withServiceCode(String serviceCode) {
        this.setServiceCode(serviceCode);
        return this;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        this.attributeNames = new ArrayList<String>(attributeNames);
    }

    public Service withAttributeNames(String ... attributeNames) {
        if (this.attributeNames == null) {
            this.setAttributeNames(new ArrayList<String>(attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    public Service withAttributeNames(Collection<String> attributeNames) {
        this.setAttributeNames(attributeNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceCode() != null) {
            sb.append("ServiceCode: ").append(this.getServiceCode()).append(",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: ").append(this.getAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.getServiceCode() == null ^ this.getServiceCode() == null) {
            return false;
        }
        if (other.getServiceCode() != null && !other.getServiceCode().equals(this.getServiceCode())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        return other.getAttributeNames() == null || other.getAttributeNames().equals(this.getAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceCode() == null ? 0 : this.getServiceCode().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        return hashCode;
    }

    public Service clone() {
        try {
            return (Service)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

