/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointemail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpointemail.model.CloudWatchDimensionConfiguration;

@SdkInternalApi
public class CloudWatchDimensionConfigurationMarshaller {
    private static final MarshallingInfo<String> DIMENSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DimensionName").build();
    private static final MarshallingInfo<String> DIMENSIONVALUESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DimensionValueSource").build();
    private static final MarshallingInfo<String> DEFAULTDIMENSIONVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultDimensionValue").build();
    private static final CloudWatchDimensionConfigurationMarshaller instance = new CloudWatchDimensionConfigurationMarshaller();

    public static CloudWatchDimensionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CloudWatchDimensionConfiguration cloudWatchDimensionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchDimensionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchDimensionConfiguration.getDimensionName(), DIMENSIONNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchDimensionConfiguration.getDimensionValueSource(), DIMENSIONVALUESOURCE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchDimensionConfiguration.getDefaultDimensionValue(), DEFAULTDIMENSIONVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

