/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.transform.EndpointSendConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointSendConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String bodyOverride;
    private Map<String, String> context;
    private String rawContent;
    private Map<String, List<String>> substitutions;
    private String titleOverride;

    public void setBodyOverride(String bodyOverride) {
        this.bodyOverride = bodyOverride;
    }

    public String getBodyOverride() {
        return this.bodyOverride;
    }

    public EndpointSendConfiguration withBodyOverride(String bodyOverride) {
        this.setBodyOverride(bodyOverride);
        return this;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public EndpointSendConfiguration withContext(Map<String, String> context) {
        this.setContext(context);
        return this;
    }

    public EndpointSendConfiguration addContextEntry(String key, String value) {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        if (this.context.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.context.put(key, value);
        return this;
    }

    public EndpointSendConfiguration clearContextEntries() {
        this.context = null;
        return this;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public EndpointSendConfiguration withRawContent(String rawContent) {
        this.setRawContent(rawContent);
        return this;
    }

    public Map<String, List<String>> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Map<String, List<String>> substitutions) {
        this.substitutions = substitutions;
    }

    public EndpointSendConfiguration withSubstitutions(Map<String, List<String>> substitutions) {
        this.setSubstitutions(substitutions);
        return this;
    }

    public EndpointSendConfiguration addSubstitutionsEntry(String key, List<String> value) {
        if (null == this.substitutions) {
            this.substitutions = new HashMap<String, List<String>>();
        }
        if (this.substitutions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.substitutions.put(key, value);
        return this;
    }

    public EndpointSendConfiguration clearSubstitutionsEntries() {
        this.substitutions = null;
        return this;
    }

    public void setTitleOverride(String titleOverride) {
        this.titleOverride = titleOverride;
    }

    public String getTitleOverride() {
        return this.titleOverride;
    }

    public EndpointSendConfiguration withTitleOverride(String titleOverride) {
        this.setTitleOverride(titleOverride);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBodyOverride() != null) {
            sb.append("BodyOverride: ").append(this.getBodyOverride()).append(",");
        }
        if (this.getContext() != null) {
            sb.append("Context: ").append(this.getContext()).append(",");
        }
        if (this.getRawContent() != null) {
            sb.append("RawContent: ").append(this.getRawContent()).append(",");
        }
        if (this.getSubstitutions() != null) {
            sb.append("Substitutions: ").append(this.getSubstitutions()).append(",");
        }
        if (this.getTitleOverride() != null) {
            sb.append("TitleOverride: ").append(this.getTitleOverride());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointSendConfiguration)) {
            return false;
        }
        EndpointSendConfiguration other = (EndpointSendConfiguration)obj;
        if (other.getBodyOverride() == null ^ this.getBodyOverride() == null) {
            return false;
        }
        if (other.getBodyOverride() != null && !other.getBodyOverride().equals(this.getBodyOverride())) {
            return false;
        }
        if (other.getContext() == null ^ this.getContext() == null) {
            return false;
        }
        if (other.getContext() != null && !other.getContext().equals(this.getContext())) {
            return false;
        }
        if (other.getRawContent() == null ^ this.getRawContent() == null) {
            return false;
        }
        if (other.getRawContent() != null && !other.getRawContent().equals(this.getRawContent())) {
            return false;
        }
        if (other.getSubstitutions() == null ^ this.getSubstitutions() == null) {
            return false;
        }
        if (other.getSubstitutions() != null && !other.getSubstitutions().equals(this.getSubstitutions())) {
            return false;
        }
        if (other.getTitleOverride() == null ^ this.getTitleOverride() == null) {
            return false;
        }
        return other.getTitleOverride() == null || other.getTitleOverride().equals(this.getTitleOverride());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBodyOverride() == null ? 0 : this.getBodyOverride().hashCode());
        hashCode = 31 * hashCode + (this.getContext() == null ? 0 : this.getContext().hashCode());
        hashCode = 31 * hashCode + (this.getRawContent() == null ? 0 : this.getRawContent().hashCode());
        hashCode = 31 * hashCode + (this.getSubstitutions() == null ? 0 : this.getSubstitutions().hashCode());
        hashCode = 31 * hashCode + (this.getTitleOverride() == null ? 0 : this.getTitleOverride().hashCode());
        return hashCode;
    }

    public EndpointSendConfiguration clone() {
        try {
            return (EndpointSendConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointSendConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

