/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.Solution;
import java.util.Date;

@SdkInternalApi
public class SolutionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> SOLUTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("solutionArn").build();
    private static final MarshallingInfo<Boolean> PERFORMHPO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performHPO").build();
    private static final MarshallingInfo<Boolean> PERFORMAUTOML_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performAutoML").build();
    private static final MarshallingInfo<Boolean> PERFORMAUTOTRAINING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("performAutoTraining").build();
    private static final MarshallingInfo<String> RECIPEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recipeArn").build();
    private static final MarshallingInfo<String> DATASETGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datasetGroupArn").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventType").build();
    private static final MarshallingInfo<StructuredPojo> SOLUTIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("solutionConfig").build();
    private static final MarshallingInfo<StructuredPojo> AUTOMLRESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoMLResult").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LATESTSOLUTIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestSolutionVersion").build();
    private static final SolutionMarshaller instance = new SolutionMarshaller();

    public static SolutionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Solution solution, ProtocolMarshaller protocolMarshaller) {
        if (solution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)solution.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)solution.getSolutionArn(), SOLUTIONARN_BINDING);
            protocolMarshaller.marshall((Object)solution.getPerformHPO(), PERFORMHPO_BINDING);
            protocolMarshaller.marshall((Object)solution.getPerformAutoML(), PERFORMAUTOML_BINDING);
            protocolMarshaller.marshall((Object)solution.getPerformAutoTraining(), PERFORMAUTOTRAINING_BINDING);
            protocolMarshaller.marshall((Object)solution.getRecipeArn(), RECIPEARN_BINDING);
            protocolMarshaller.marshall((Object)solution.getDatasetGroupArn(), DATASETGROUPARN_BINDING);
            protocolMarshaller.marshall((Object)solution.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)solution.getSolutionConfig(), SOLUTIONCONFIG_BINDING);
            protocolMarshaller.marshall((Object)solution.getAutoMLResult(), AUTOMLRESULT_BINDING);
            protocolMarshaller.marshall((Object)solution.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)solution.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)solution.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)solution.getLatestSolutionVersion(), LATESTSOLUTIONVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

