/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorad.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pcaconnectorad.model.PrivateKeyAttributesV2;
import java.util.List;

@SdkInternalApi
public class PrivateKeyAttributesV2Marshaller {
    private static final MarshallingInfo<List> CRYPTOPROVIDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CryptoProviders").build();
    private static final MarshallingInfo<String> KEYSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySpec").build();
    private static final MarshallingInfo<Integer> MINIMALKEYLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimalKeyLength").build();
    private static final PrivateKeyAttributesV2Marshaller instance = new PrivateKeyAttributesV2Marshaller();

    public static PrivateKeyAttributesV2Marshaller getInstance() {
        return instance;
    }

    public void marshall(PrivateKeyAttributesV2 privateKeyAttributesV2, ProtocolMarshaller protocolMarshaller) {
        if (privateKeyAttributesV2 == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(privateKeyAttributesV2.getCryptoProviders(), CRYPTOPROVIDERS_BINDING);
            protocolMarshaller.marshall((Object)privateKeyAttributesV2.getKeySpec(), KEYSPEC_BINDING);
            protocolMarshaller.marshall((Object)privateKeyAttributesV2.getMinimalKeyLength(), MINIMALKEYLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

