/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorad.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pcaconnectorad.model.KeySpec;
import com.amazonaws.services.pcaconnectorad.model.KeyUsageProperty;
import com.amazonaws.services.pcaconnectorad.model.PrivateKeyAlgorithm;
import com.amazonaws.services.pcaconnectorad.model.transform.PrivateKeyAttributesV3Marshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrivateKeyAttributesV3
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithm;
    private List<String> cryptoProviders;
    private String keySpec;
    private KeyUsageProperty keyUsageProperty;
    private Integer minimalKeyLength;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public PrivateKeyAttributesV3 withAlgorithm(String algorithm) {
        this.setAlgorithm(algorithm);
        return this;
    }

    public PrivateKeyAttributesV3 withAlgorithm(PrivateKeyAlgorithm algorithm) {
        this.algorithm = algorithm.toString();
        return this;
    }

    public List<String> getCryptoProviders() {
        return this.cryptoProviders;
    }

    public void setCryptoProviders(Collection<String> cryptoProviders) {
        if (cryptoProviders == null) {
            this.cryptoProviders = null;
            return;
        }
        this.cryptoProviders = new ArrayList<String>(cryptoProviders);
    }

    public PrivateKeyAttributesV3 withCryptoProviders(String ... cryptoProviders) {
        if (this.cryptoProviders == null) {
            this.setCryptoProviders(new ArrayList<String>(cryptoProviders.length));
        }
        for (String ele : cryptoProviders) {
            this.cryptoProviders.add(ele);
        }
        return this;
    }

    public PrivateKeyAttributesV3 withCryptoProviders(Collection<String> cryptoProviders) {
        this.setCryptoProviders(cryptoProviders);
        return this;
    }

    public void setKeySpec(String keySpec) {
        this.keySpec = keySpec;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public PrivateKeyAttributesV3 withKeySpec(String keySpec) {
        this.setKeySpec(keySpec);
        return this;
    }

    public PrivateKeyAttributesV3 withKeySpec(KeySpec keySpec) {
        this.keySpec = keySpec.toString();
        return this;
    }

    public void setKeyUsageProperty(KeyUsageProperty keyUsageProperty) {
        this.keyUsageProperty = keyUsageProperty;
    }

    public KeyUsageProperty getKeyUsageProperty() {
        return this.keyUsageProperty;
    }

    public PrivateKeyAttributesV3 withKeyUsageProperty(KeyUsageProperty keyUsageProperty) {
        this.setKeyUsageProperty(keyUsageProperty);
        return this;
    }

    public void setMinimalKeyLength(Integer minimalKeyLength) {
        this.minimalKeyLength = minimalKeyLength;
    }

    public Integer getMinimalKeyLength() {
        return this.minimalKeyLength;
    }

    public PrivateKeyAttributesV3 withMinimalKeyLength(Integer minimalKeyLength) {
        this.setMinimalKeyLength(minimalKeyLength);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithm() != null) {
            sb.append("Algorithm: ").append(this.getAlgorithm()).append(",");
        }
        if (this.getCryptoProviders() != null) {
            sb.append("CryptoProviders: ").append(this.getCryptoProviders()).append(",");
        }
        if (this.getKeySpec() != null) {
            sb.append("KeySpec: ").append(this.getKeySpec()).append(",");
        }
        if (this.getKeyUsageProperty() != null) {
            sb.append("KeyUsageProperty: ").append(this.getKeyUsageProperty()).append(",");
        }
        if (this.getMinimalKeyLength() != null) {
            sb.append("MinimalKeyLength: ").append(this.getMinimalKeyLength());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateKeyAttributesV3)) {
            return false;
        }
        PrivateKeyAttributesV3 other = (PrivateKeyAttributesV3)obj;
        if (other.getAlgorithm() == null ^ this.getAlgorithm() == null) {
            return false;
        }
        if (other.getAlgorithm() != null && !other.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (other.getCryptoProviders() == null ^ this.getCryptoProviders() == null) {
            return false;
        }
        if (other.getCryptoProviders() != null && !other.getCryptoProviders().equals(this.getCryptoProviders())) {
            return false;
        }
        if (other.getKeySpec() == null ^ this.getKeySpec() == null) {
            return false;
        }
        if (other.getKeySpec() != null && !other.getKeySpec().equals(this.getKeySpec())) {
            return false;
        }
        if (other.getKeyUsageProperty() == null ^ this.getKeyUsageProperty() == null) {
            return false;
        }
        if (other.getKeyUsageProperty() != null && !other.getKeyUsageProperty().equals(this.getKeyUsageProperty())) {
            return false;
        }
        if (other.getMinimalKeyLength() == null ^ this.getMinimalKeyLength() == null) {
            return false;
        }
        return other.getMinimalKeyLength() == null || other.getMinimalKeyLength().equals(this.getMinimalKeyLength());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithm() == null ? 0 : this.getAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getCryptoProviders() == null ? 0 : this.getCryptoProviders().hashCode());
        hashCode = 31 * hashCode + (this.getKeySpec() == null ? 0 : this.getKeySpec().hashCode());
        hashCode = 31 * hashCode + (this.getKeyUsageProperty() == null ? 0 : this.getKeyUsageProperty().hashCode());
        hashCode = 31 * hashCode + (this.getMinimalKeyLength() == null ? 0 : this.getMinimalKeyLength().hashCode());
        return hashCode;
    }

    public PrivateKeyAttributesV3 clone() {
        try {
            return (PrivateKeyAttributesV3)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrivateKeyAttributesV3Marshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

