/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.paymentcryptographydata.model.EncryptionDecryptionAttributes;
import java.io.Serializable;

public class DecryptDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cipherText;
    private EncryptionDecryptionAttributes decryptionAttributes;
    private String keyIdentifier;

    public void setCipherText(String cipherText) {
        this.cipherText = cipherText;
    }

    public String getCipherText() {
        return this.cipherText;
    }

    public DecryptDataRequest withCipherText(String cipherText) {
        this.setCipherText(cipherText);
        return this;
    }

    public void setDecryptionAttributes(EncryptionDecryptionAttributes decryptionAttributes) {
        this.decryptionAttributes = decryptionAttributes;
    }

    public EncryptionDecryptionAttributes getDecryptionAttributes() {
        return this.decryptionAttributes;
    }

    public DecryptDataRequest withDecryptionAttributes(EncryptionDecryptionAttributes decryptionAttributes) {
        this.setDecryptionAttributes(decryptionAttributes);
        return this;
    }

    public void setKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public DecryptDataRequest withKeyIdentifier(String keyIdentifier) {
        this.setKeyIdentifier(keyIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCipherText() != null) {
            sb.append("CipherText: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDecryptionAttributes() != null) {
            sb.append("DecryptionAttributes: ").append(this.getDecryptionAttributes()).append(",");
        }
        if (this.getKeyIdentifier() != null) {
            sb.append("KeyIdentifier: ").append(this.getKeyIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptDataRequest)) {
            return false;
        }
        DecryptDataRequest other = (DecryptDataRequest)obj;
        if (other.getCipherText() == null ^ this.getCipherText() == null) {
            return false;
        }
        if (other.getCipherText() != null && !other.getCipherText().equals(this.getCipherText())) {
            return false;
        }
        if (other.getDecryptionAttributes() == null ^ this.getDecryptionAttributes() == null) {
            return false;
        }
        if (other.getDecryptionAttributes() != null && !other.getDecryptionAttributes().equals(this.getDecryptionAttributes())) {
            return false;
        }
        if (other.getKeyIdentifier() == null ^ this.getKeyIdentifier() == null) {
            return false;
        }
        return other.getKeyIdentifier() == null || other.getKeyIdentifier().equals(this.getKeyIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCipherText() == null ? 0 : this.getCipherText().hashCode());
        hashCode = 31 * hashCode + (this.getDecryptionAttributes() == null ? 0 : this.getDecryptionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getKeyIdentifier() == null ? 0 : this.getKeyIdentifier().hashCode());
        return hashCode;
    }

    public DecryptDataRequest clone() {
        return (DecryptDataRequest)super.clone();
    }
}

