/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.paymentcryptographydata.AWSPaymentCryptographyDataAsync;
import com.amazonaws.services.paymentcryptographydata.AWSPaymentCryptographyDataAsyncClientBuilder;
import com.amazonaws.services.paymentcryptographydata.AWSPaymentCryptographyDataClient;
import com.amazonaws.services.paymentcryptographydata.model.DecryptDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.DecryptDataResult;
import com.amazonaws.services.paymentcryptographydata.model.EncryptDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.EncryptDataResult;
import com.amazonaws.services.paymentcryptographydata.model.GenerateCardValidationDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.GenerateCardValidationDataResult;
import com.amazonaws.services.paymentcryptographydata.model.GenerateMacRequest;
import com.amazonaws.services.paymentcryptographydata.model.GenerateMacResult;
import com.amazonaws.services.paymentcryptographydata.model.GeneratePinDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.GeneratePinDataResult;
import com.amazonaws.services.paymentcryptographydata.model.ReEncryptDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.ReEncryptDataResult;
import com.amazonaws.services.paymentcryptographydata.model.TranslatePinDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.TranslatePinDataResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyAuthRequestCryptogramResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyCardValidationDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyCardValidationDataResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyMacRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyMacResult;
import com.amazonaws.services.paymentcryptographydata.model.VerifyPinDataRequest;
import com.amazonaws.services.paymentcryptographydata.model.VerifyPinDataResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSPaymentCryptographyDataAsyncClient
extends AWSPaymentCryptographyDataClient
implements AWSPaymentCryptographyDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSPaymentCryptographyDataAsyncClientBuilder asyncBuilder() {
        return AWSPaymentCryptographyDataAsyncClientBuilder.standard();
    }

    AWSPaymentCryptographyDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSPaymentCryptographyDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DecryptDataResult> decryptDataAsync(DecryptDataRequest request) {
        return this.decryptDataAsync(request, null);
    }

    @Override
    public Future<DecryptDataResult> decryptDataAsync(DecryptDataRequest request, final AsyncHandler<DecryptDataRequest, DecryptDataResult> asyncHandler) {
        final DecryptDataRequest finalRequest = (DecryptDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DecryptDataResult>(){

            @Override
            public DecryptDataResult call() throws Exception {
                DecryptDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeDecryptData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EncryptDataResult> encryptDataAsync(EncryptDataRequest request) {
        return this.encryptDataAsync(request, null);
    }

    @Override
    public Future<EncryptDataResult> encryptDataAsync(EncryptDataRequest request, final AsyncHandler<EncryptDataRequest, EncryptDataResult> asyncHandler) {
        final EncryptDataRequest finalRequest = (EncryptDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EncryptDataResult>(){

            @Override
            public EncryptDataResult call() throws Exception {
                EncryptDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeEncryptData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateCardValidationDataResult> generateCardValidationDataAsync(GenerateCardValidationDataRequest request) {
        return this.generateCardValidationDataAsync(request, null);
    }

    @Override
    public Future<GenerateCardValidationDataResult> generateCardValidationDataAsync(GenerateCardValidationDataRequest request, final AsyncHandler<GenerateCardValidationDataRequest, GenerateCardValidationDataResult> asyncHandler) {
        final GenerateCardValidationDataRequest finalRequest = (GenerateCardValidationDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GenerateCardValidationDataResult>(){

            @Override
            public GenerateCardValidationDataResult call() throws Exception {
                GenerateCardValidationDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeGenerateCardValidationData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GenerateMacResult> generateMacAsync(GenerateMacRequest request) {
        return this.generateMacAsync(request, null);
    }

    @Override
    public Future<GenerateMacResult> generateMacAsync(GenerateMacRequest request, final AsyncHandler<GenerateMacRequest, GenerateMacResult> asyncHandler) {
        final GenerateMacRequest finalRequest = (GenerateMacRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GenerateMacResult>(){

            @Override
            public GenerateMacResult call() throws Exception {
                GenerateMacResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeGenerateMac(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GeneratePinDataResult> generatePinDataAsync(GeneratePinDataRequest request) {
        return this.generatePinDataAsync(request, null);
    }

    @Override
    public Future<GeneratePinDataResult> generatePinDataAsync(GeneratePinDataRequest request, final AsyncHandler<GeneratePinDataRequest, GeneratePinDataResult> asyncHandler) {
        final GeneratePinDataRequest finalRequest = (GeneratePinDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GeneratePinDataResult>(){

            @Override
            public GeneratePinDataResult call() throws Exception {
                GeneratePinDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeGeneratePinData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReEncryptDataResult> reEncryptDataAsync(ReEncryptDataRequest request) {
        return this.reEncryptDataAsync(request, null);
    }

    @Override
    public Future<ReEncryptDataResult> reEncryptDataAsync(ReEncryptDataRequest request, final AsyncHandler<ReEncryptDataRequest, ReEncryptDataResult> asyncHandler) {
        final ReEncryptDataRequest finalRequest = (ReEncryptDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReEncryptDataResult>(){

            @Override
            public ReEncryptDataResult call() throws Exception {
                ReEncryptDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeReEncryptData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TranslatePinDataResult> translatePinDataAsync(TranslatePinDataRequest request) {
        return this.translatePinDataAsync(request, null);
    }

    @Override
    public Future<TranslatePinDataResult> translatePinDataAsync(TranslatePinDataRequest request, final AsyncHandler<TranslatePinDataRequest, TranslatePinDataResult> asyncHandler) {
        final TranslatePinDataRequest finalRequest = (TranslatePinDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TranslatePinDataResult>(){

            @Override
            public TranslatePinDataResult call() throws Exception {
                TranslatePinDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeTranslatePinData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyAuthRequestCryptogramResult> verifyAuthRequestCryptogramAsync(VerifyAuthRequestCryptogramRequest request) {
        return this.verifyAuthRequestCryptogramAsync(request, null);
    }

    @Override
    public Future<VerifyAuthRequestCryptogramResult> verifyAuthRequestCryptogramAsync(VerifyAuthRequestCryptogramRequest request, final AsyncHandler<VerifyAuthRequestCryptogramRequest, VerifyAuthRequestCryptogramResult> asyncHandler) {
        final VerifyAuthRequestCryptogramRequest finalRequest = (VerifyAuthRequestCryptogramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VerifyAuthRequestCryptogramResult>(){

            @Override
            public VerifyAuthRequestCryptogramResult call() throws Exception {
                VerifyAuthRequestCryptogramResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeVerifyAuthRequestCryptogram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyCardValidationDataResult> verifyCardValidationDataAsync(VerifyCardValidationDataRequest request) {
        return this.verifyCardValidationDataAsync(request, null);
    }

    @Override
    public Future<VerifyCardValidationDataResult> verifyCardValidationDataAsync(VerifyCardValidationDataRequest request, final AsyncHandler<VerifyCardValidationDataRequest, VerifyCardValidationDataResult> asyncHandler) {
        final VerifyCardValidationDataRequest finalRequest = (VerifyCardValidationDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VerifyCardValidationDataResult>(){

            @Override
            public VerifyCardValidationDataResult call() throws Exception {
                VerifyCardValidationDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeVerifyCardValidationData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyMacResult> verifyMacAsync(VerifyMacRequest request) {
        return this.verifyMacAsync(request, null);
    }

    @Override
    public Future<VerifyMacResult> verifyMacAsync(VerifyMacRequest request, final AsyncHandler<VerifyMacRequest, VerifyMacResult> asyncHandler) {
        final VerifyMacRequest finalRequest = (VerifyMacRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VerifyMacResult>(){

            @Override
            public VerifyMacResult call() throws Exception {
                VerifyMacResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeVerifyMac(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyPinDataResult> verifyPinDataAsync(VerifyPinDataRequest request) {
        return this.verifyPinDataAsync(request, null);
    }

    @Override
    public Future<VerifyPinDataResult> verifyPinDataAsync(VerifyPinDataRequest request, final AsyncHandler<VerifyPinDataRequest, VerifyPinDataResult> asyncHandler) {
        final VerifyPinDataRequest finalRequest = (VerifyPinDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VerifyPinDataResult>(){

            @Override
            public VerifyPinDataResult call() throws Exception {
                VerifyPinDataResult result = null;
                try {
                    result = AWSPaymentCryptographyDataAsyncClient.this.executeVerifyPinData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

