/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.paymentcryptographydata.model.DukptAttributes;
import com.amazonaws.services.paymentcryptographydata.model.PinBlockFormatForPinData;
import com.amazonaws.services.paymentcryptographydata.model.PinVerificationAttributes;
import java.io.Serializable;

public class VerifyPinDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DukptAttributes dukptAttributes;
    private String encryptedPinBlock;
    private String encryptionKeyIdentifier;
    private String pinBlockFormat;
    private Integer pinDataLength;
    private String primaryAccountNumber;
    private PinVerificationAttributes verificationAttributes;
    private String verificationKeyIdentifier;

    public void setDukptAttributes(DukptAttributes dukptAttributes) {
        this.dukptAttributes = dukptAttributes;
    }

    public DukptAttributes getDukptAttributes() {
        return this.dukptAttributes;
    }

    public VerifyPinDataRequest withDukptAttributes(DukptAttributes dukptAttributes) {
        this.setDukptAttributes(dukptAttributes);
        return this;
    }

    public void setEncryptedPinBlock(String encryptedPinBlock) {
        this.encryptedPinBlock = encryptedPinBlock;
    }

    public String getEncryptedPinBlock() {
        return this.encryptedPinBlock;
    }

    public VerifyPinDataRequest withEncryptedPinBlock(String encryptedPinBlock) {
        this.setEncryptedPinBlock(encryptedPinBlock);
        return this;
    }

    public void setEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
        this.encryptionKeyIdentifier = encryptionKeyIdentifier;
    }

    public String getEncryptionKeyIdentifier() {
        return this.encryptionKeyIdentifier;
    }

    public VerifyPinDataRequest withEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
        this.setEncryptionKeyIdentifier(encryptionKeyIdentifier);
        return this;
    }

    public void setPinBlockFormat(String pinBlockFormat) {
        this.pinBlockFormat = pinBlockFormat;
    }

    public String getPinBlockFormat() {
        return this.pinBlockFormat;
    }

    public VerifyPinDataRequest withPinBlockFormat(String pinBlockFormat) {
        this.setPinBlockFormat(pinBlockFormat);
        return this;
    }

    public VerifyPinDataRequest withPinBlockFormat(PinBlockFormatForPinData pinBlockFormat) {
        this.pinBlockFormat = pinBlockFormat.toString();
        return this;
    }

    public void setPinDataLength(Integer pinDataLength) {
        this.pinDataLength = pinDataLength;
    }

    public Integer getPinDataLength() {
        return this.pinDataLength;
    }

    public VerifyPinDataRequest withPinDataLength(Integer pinDataLength) {
        this.setPinDataLength(pinDataLength);
        return this;
    }

    public void setPrimaryAccountNumber(String primaryAccountNumber) {
        this.primaryAccountNumber = primaryAccountNumber;
    }

    public String getPrimaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public VerifyPinDataRequest withPrimaryAccountNumber(String primaryAccountNumber) {
        this.setPrimaryAccountNumber(primaryAccountNumber);
        return this;
    }

    public void setVerificationAttributes(PinVerificationAttributes verificationAttributes) {
        this.verificationAttributes = verificationAttributes;
    }

    public PinVerificationAttributes getVerificationAttributes() {
        return this.verificationAttributes;
    }

    public VerifyPinDataRequest withVerificationAttributes(PinVerificationAttributes verificationAttributes) {
        this.setVerificationAttributes(verificationAttributes);
        return this;
    }

    public void setVerificationKeyIdentifier(String verificationKeyIdentifier) {
        this.verificationKeyIdentifier = verificationKeyIdentifier;
    }

    public String getVerificationKeyIdentifier() {
        return this.verificationKeyIdentifier;
    }

    public VerifyPinDataRequest withVerificationKeyIdentifier(String verificationKeyIdentifier) {
        this.setVerificationKeyIdentifier(verificationKeyIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDukptAttributes() != null) {
            sb.append("DukptAttributes: ").append(this.getDukptAttributes()).append(",");
        }
        if (this.getEncryptedPinBlock() != null) {
            sb.append("EncryptedPinBlock: ").append(this.getEncryptedPinBlock()).append(",");
        }
        if (this.getEncryptionKeyIdentifier() != null) {
            sb.append("EncryptionKeyIdentifier: ").append(this.getEncryptionKeyIdentifier()).append(",");
        }
        if (this.getPinBlockFormat() != null) {
            sb.append("PinBlockFormat: ").append(this.getPinBlockFormat()).append(",");
        }
        if (this.getPinDataLength() != null) {
            sb.append("PinDataLength: ").append(this.getPinDataLength()).append(",");
        }
        if (this.getPrimaryAccountNumber() != null) {
            sb.append("PrimaryAccountNumber: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getVerificationAttributes() != null) {
            sb.append("VerificationAttributes: ").append(this.getVerificationAttributes()).append(",");
        }
        if (this.getVerificationKeyIdentifier() != null) {
            sb.append("VerificationKeyIdentifier: ").append(this.getVerificationKeyIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyPinDataRequest)) {
            return false;
        }
        VerifyPinDataRequest other = (VerifyPinDataRequest)obj;
        if (other.getDukptAttributes() == null ^ this.getDukptAttributes() == null) {
            return false;
        }
        if (other.getDukptAttributes() != null && !other.getDukptAttributes().equals(this.getDukptAttributes())) {
            return false;
        }
        if (other.getEncryptedPinBlock() == null ^ this.getEncryptedPinBlock() == null) {
            return false;
        }
        if (other.getEncryptedPinBlock() != null && !other.getEncryptedPinBlock().equals(this.getEncryptedPinBlock())) {
            return false;
        }
        if (other.getEncryptionKeyIdentifier() == null ^ this.getEncryptionKeyIdentifier() == null) {
            return false;
        }
        if (other.getEncryptionKeyIdentifier() != null && !other.getEncryptionKeyIdentifier().equals(this.getEncryptionKeyIdentifier())) {
            return false;
        }
        if (other.getPinBlockFormat() == null ^ this.getPinBlockFormat() == null) {
            return false;
        }
        if (other.getPinBlockFormat() != null && !other.getPinBlockFormat().equals(this.getPinBlockFormat())) {
            return false;
        }
        if (other.getPinDataLength() == null ^ this.getPinDataLength() == null) {
            return false;
        }
        if (other.getPinDataLength() != null && !other.getPinDataLength().equals(this.getPinDataLength())) {
            return false;
        }
        if (other.getPrimaryAccountNumber() == null ^ this.getPrimaryAccountNumber() == null) {
            return false;
        }
        if (other.getPrimaryAccountNumber() != null && !other.getPrimaryAccountNumber().equals(this.getPrimaryAccountNumber())) {
            return false;
        }
        if (other.getVerificationAttributes() == null ^ this.getVerificationAttributes() == null) {
            return false;
        }
        if (other.getVerificationAttributes() != null && !other.getVerificationAttributes().equals(this.getVerificationAttributes())) {
            return false;
        }
        if (other.getVerificationKeyIdentifier() == null ^ this.getVerificationKeyIdentifier() == null) {
            return false;
        }
        return other.getVerificationKeyIdentifier() == null || other.getVerificationKeyIdentifier().equals(this.getVerificationKeyIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDukptAttributes() == null ? 0 : this.getDukptAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptedPinBlock() == null ? 0 : this.getEncryptedPinBlock().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKeyIdentifier() == null ? 0 : this.getEncryptionKeyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getPinBlockFormat() == null ? 0 : this.getPinBlockFormat().hashCode());
        hashCode = 31 * hashCode + (this.getPinDataLength() == null ? 0 : this.getPinDataLength().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryAccountNumber() == null ? 0 : this.getPrimaryAccountNumber().hashCode());
        hashCode = 31 * hashCode + (this.getVerificationAttributes() == null ? 0 : this.getVerificationAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getVerificationKeyIdentifier() == null ? 0 : this.getVerificationKeyIdentifier().hashCode());
        return hashCode;
    }

    public VerifyPinDataRequest clone() {
        return (VerifyPinDataRequest)super.clone();
    }
}

