/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.panorama.model.ApplicationInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ApplicationInstance> applicationInstances;
    private String nextToken;

    public List<ApplicationInstance> getApplicationInstances() {
        return this.applicationInstances;
    }

    public void setApplicationInstances(Collection<ApplicationInstance> applicationInstances) {
        if (applicationInstances == null) {
            this.applicationInstances = null;
            return;
        }
        this.applicationInstances = new ArrayList<ApplicationInstance>(applicationInstances);
    }

    public ListApplicationInstancesResult withApplicationInstances(ApplicationInstance ... applicationInstances) {
        if (this.applicationInstances == null) {
            this.setApplicationInstances(new ArrayList<ApplicationInstance>(applicationInstances.length));
        }
        for (ApplicationInstance ele : applicationInstances) {
            this.applicationInstances.add(ele);
        }
        return this;
    }

    public ListApplicationInstancesResult withApplicationInstances(Collection<ApplicationInstance> applicationInstances) {
        this.setApplicationInstances(applicationInstances);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationInstancesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationInstances() != null) {
            sb.append("ApplicationInstances: ").append(this.getApplicationInstances()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstancesResult)) {
            return false;
        }
        ListApplicationInstancesResult other = (ListApplicationInstancesResult)obj;
        if (other.getApplicationInstances() == null ^ this.getApplicationInstances() == null) {
            return false;
        }
        if (other.getApplicationInstances() != null && !other.getApplicationInstances().equals(this.getApplicationInstances())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationInstances() == null ? 0 : this.getApplicationInstances().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListApplicationInstancesResult clone() {
        try {
            return (ListApplicationInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

