/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.RackPhysicalProperties;
import com.amazonaws.services.outposts.model.transform.SiteMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Site
implements Serializable,
Cloneable,
StructuredPojo {
    private String siteId;
    private String accountId;
    private String name;
    private String description;
    private Map<String, String> tags;
    private String siteArn;
    private String notes;
    private String operatingAddressCountryCode;
    private String operatingAddressStateOrRegion;
    private String operatingAddressCity;
    private RackPhysicalProperties rackPhysicalProperties;

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public Site withSiteId(String siteId) {
        this.setSiteId(siteId);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Site withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Site withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Site withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Site withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Site addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Site clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setSiteArn(String siteArn) {
        this.siteArn = siteArn;
    }

    public String getSiteArn() {
        return this.siteArn;
    }

    public Site withSiteArn(String siteArn) {
        this.setSiteArn(siteArn);
        return this;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public Site withNotes(String notes) {
        this.setNotes(notes);
        return this;
    }

    public void setOperatingAddressCountryCode(String operatingAddressCountryCode) {
        this.operatingAddressCountryCode = operatingAddressCountryCode;
    }

    public String getOperatingAddressCountryCode() {
        return this.operatingAddressCountryCode;
    }

    public Site withOperatingAddressCountryCode(String operatingAddressCountryCode) {
        this.setOperatingAddressCountryCode(operatingAddressCountryCode);
        return this;
    }

    public void setOperatingAddressStateOrRegion(String operatingAddressStateOrRegion) {
        this.operatingAddressStateOrRegion = operatingAddressStateOrRegion;
    }

    public String getOperatingAddressStateOrRegion() {
        return this.operatingAddressStateOrRegion;
    }

    public Site withOperatingAddressStateOrRegion(String operatingAddressStateOrRegion) {
        this.setOperatingAddressStateOrRegion(operatingAddressStateOrRegion);
        return this;
    }

    public void setOperatingAddressCity(String operatingAddressCity) {
        this.operatingAddressCity = operatingAddressCity;
    }

    public String getOperatingAddressCity() {
        return this.operatingAddressCity;
    }

    public Site withOperatingAddressCity(String operatingAddressCity) {
        this.setOperatingAddressCity(operatingAddressCity);
        return this;
    }

    public void setRackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
        this.rackPhysicalProperties = rackPhysicalProperties;
    }

    public RackPhysicalProperties getRackPhysicalProperties() {
        return this.rackPhysicalProperties;
    }

    public Site withRackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
        this.setRackPhysicalProperties(rackPhysicalProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSiteId() != null) {
            sb.append("SiteId: ").append(this.getSiteId()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSiteArn() != null) {
            sb.append("SiteArn: ").append(this.getSiteArn()).append(",");
        }
        if (this.getNotes() != null) {
            sb.append("Notes: ").append(this.getNotes()).append(",");
        }
        if (this.getOperatingAddressCountryCode() != null) {
            sb.append("OperatingAddressCountryCode: ").append(this.getOperatingAddressCountryCode()).append(",");
        }
        if (this.getOperatingAddressStateOrRegion() != null) {
            sb.append("OperatingAddressStateOrRegion: ").append(this.getOperatingAddressStateOrRegion()).append(",");
        }
        if (this.getOperatingAddressCity() != null) {
            sb.append("OperatingAddressCity: ").append(this.getOperatingAddressCity()).append(",");
        }
        if (this.getRackPhysicalProperties() != null) {
            sb.append("RackPhysicalProperties: ").append(this.getRackPhysicalProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Site)) {
            return false;
        }
        Site other = (Site)obj;
        if (other.getSiteId() == null ^ this.getSiteId() == null) {
            return false;
        }
        if (other.getSiteId() != null && !other.getSiteId().equals(this.getSiteId())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSiteArn() == null ^ this.getSiteArn() == null) {
            return false;
        }
        if (other.getSiteArn() != null && !other.getSiteArn().equals(this.getSiteArn())) {
            return false;
        }
        if (other.getNotes() == null ^ this.getNotes() == null) {
            return false;
        }
        if (other.getNotes() != null && !other.getNotes().equals(this.getNotes())) {
            return false;
        }
        if (other.getOperatingAddressCountryCode() == null ^ this.getOperatingAddressCountryCode() == null) {
            return false;
        }
        if (other.getOperatingAddressCountryCode() != null && !other.getOperatingAddressCountryCode().equals(this.getOperatingAddressCountryCode())) {
            return false;
        }
        if (other.getOperatingAddressStateOrRegion() == null ^ this.getOperatingAddressStateOrRegion() == null) {
            return false;
        }
        if (other.getOperatingAddressStateOrRegion() != null && !other.getOperatingAddressStateOrRegion().equals(this.getOperatingAddressStateOrRegion())) {
            return false;
        }
        if (other.getOperatingAddressCity() == null ^ this.getOperatingAddressCity() == null) {
            return false;
        }
        if (other.getOperatingAddressCity() != null && !other.getOperatingAddressCity().equals(this.getOperatingAddressCity())) {
            return false;
        }
        if (other.getRackPhysicalProperties() == null ^ this.getRackPhysicalProperties() == null) {
            return false;
        }
        return other.getRackPhysicalProperties() == null || other.getRackPhysicalProperties().equals(this.getRackPhysicalProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSiteId() == null ? 0 : this.getSiteId().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSiteArn() == null ? 0 : this.getSiteArn().hashCode());
        hashCode = 31 * hashCode + (this.getNotes() == null ? 0 : this.getNotes().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingAddressCountryCode() == null ? 0 : this.getOperatingAddressCountryCode().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingAddressStateOrRegion() == null ? 0 : this.getOperatingAddressStateOrRegion().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingAddressCity() == null ? 0 : this.getOperatingAddressCity().hashCode());
        hashCode = 31 * hashCode + (this.getRackPhysicalProperties() == null ? 0 : this.getRackPhysicalProperties().hashCode());
        return hashCode;
    }

    public Site clone() {
        try {
            return (Site)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SiteMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

