/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.outposts.model.transform.ConnectionDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectionDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String clientPublicKey;
    private String serverPublicKey;
    private String serverEndpoint;
    private String clientTunnelAddress;
    private String serverTunnelAddress;
    private List<String> allowedIps;

    public void setClientPublicKey(String clientPublicKey) {
        this.clientPublicKey = clientPublicKey;
    }

    public String getClientPublicKey() {
        return this.clientPublicKey;
    }

    public ConnectionDetails withClientPublicKey(String clientPublicKey) {
        this.setClientPublicKey(clientPublicKey);
        return this;
    }

    public void setServerPublicKey(String serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    public String getServerPublicKey() {
        return this.serverPublicKey;
    }

    public ConnectionDetails withServerPublicKey(String serverPublicKey) {
        this.setServerPublicKey(serverPublicKey);
        return this;
    }

    public void setServerEndpoint(String serverEndpoint) {
        this.serverEndpoint = serverEndpoint;
    }

    public String getServerEndpoint() {
        return this.serverEndpoint;
    }

    public ConnectionDetails withServerEndpoint(String serverEndpoint) {
        this.setServerEndpoint(serverEndpoint);
        return this;
    }

    public void setClientTunnelAddress(String clientTunnelAddress) {
        this.clientTunnelAddress = clientTunnelAddress;
    }

    public String getClientTunnelAddress() {
        return this.clientTunnelAddress;
    }

    public ConnectionDetails withClientTunnelAddress(String clientTunnelAddress) {
        this.setClientTunnelAddress(clientTunnelAddress);
        return this;
    }

    public void setServerTunnelAddress(String serverTunnelAddress) {
        this.serverTunnelAddress = serverTunnelAddress;
    }

    public String getServerTunnelAddress() {
        return this.serverTunnelAddress;
    }

    public ConnectionDetails withServerTunnelAddress(String serverTunnelAddress) {
        this.setServerTunnelAddress(serverTunnelAddress);
        return this;
    }

    public List<String> getAllowedIps() {
        return this.allowedIps;
    }

    public void setAllowedIps(Collection<String> allowedIps) {
        if (allowedIps == null) {
            this.allowedIps = null;
            return;
        }
        this.allowedIps = new ArrayList<String>(allowedIps);
    }

    public ConnectionDetails withAllowedIps(String ... allowedIps) {
        if (this.allowedIps == null) {
            this.setAllowedIps(new ArrayList<String>(allowedIps.length));
        }
        for (String ele : allowedIps) {
            this.allowedIps.add(ele);
        }
        return this;
    }

    public ConnectionDetails withAllowedIps(Collection<String> allowedIps) {
        this.setAllowedIps(allowedIps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientPublicKey() != null) {
            sb.append("ClientPublicKey: ").append(this.getClientPublicKey()).append(",");
        }
        if (this.getServerPublicKey() != null) {
            sb.append("ServerPublicKey: ").append(this.getServerPublicKey()).append(",");
        }
        if (this.getServerEndpoint() != null) {
            sb.append("ServerEndpoint: ").append(this.getServerEndpoint()).append(",");
        }
        if (this.getClientTunnelAddress() != null) {
            sb.append("ClientTunnelAddress: ").append(this.getClientTunnelAddress()).append(",");
        }
        if (this.getServerTunnelAddress() != null) {
            sb.append("ServerTunnelAddress: ").append(this.getServerTunnelAddress()).append(",");
        }
        if (this.getAllowedIps() != null) {
            sb.append("AllowedIps: ").append(this.getAllowedIps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)obj;
        if (other.getClientPublicKey() == null ^ this.getClientPublicKey() == null) {
            return false;
        }
        if (other.getClientPublicKey() != null && !other.getClientPublicKey().equals(this.getClientPublicKey())) {
            return false;
        }
        if (other.getServerPublicKey() == null ^ this.getServerPublicKey() == null) {
            return false;
        }
        if (other.getServerPublicKey() != null && !other.getServerPublicKey().equals(this.getServerPublicKey())) {
            return false;
        }
        if (other.getServerEndpoint() == null ^ this.getServerEndpoint() == null) {
            return false;
        }
        if (other.getServerEndpoint() != null && !other.getServerEndpoint().equals(this.getServerEndpoint())) {
            return false;
        }
        if (other.getClientTunnelAddress() == null ^ this.getClientTunnelAddress() == null) {
            return false;
        }
        if (other.getClientTunnelAddress() != null && !other.getClientTunnelAddress().equals(this.getClientTunnelAddress())) {
            return false;
        }
        if (other.getServerTunnelAddress() == null ^ this.getServerTunnelAddress() == null) {
            return false;
        }
        if (other.getServerTunnelAddress() != null && !other.getServerTunnelAddress().equals(this.getServerTunnelAddress())) {
            return false;
        }
        if (other.getAllowedIps() == null ^ this.getAllowedIps() == null) {
            return false;
        }
        return other.getAllowedIps() == null || other.getAllowedIps().equals(this.getAllowedIps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientPublicKey() == null ? 0 : this.getClientPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getServerPublicKey() == null ? 0 : this.getServerPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getServerEndpoint() == null ? 0 : this.getServerEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getClientTunnelAddress() == null ? 0 : this.getClientTunnelAddress().hashCode());
        hashCode = 31 * hashCode + (this.getServerTunnelAddress() == null ? 0 : this.getServerTunnelAddress().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedIps() == null ? 0 : this.getAllowedIps().hashCode());
        return hashCode;
    }

    public ConnectionDetails clone() {
        try {
            return (ConnectionDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

