/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.outposts.model.CatalogItemClass;
import com.amazonaws.services.outposts.model.SupportedStorageEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCatalogItemsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String nextToken;
    private Integer maxResults;
    private List<String> itemClassFilter;
    private List<String> supportedStorageFilter;
    private List<String> eC2FamilyFilter;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCatalogItemsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListCatalogItemsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<String> getItemClassFilter() {
        return this.itemClassFilter;
    }

    public void setItemClassFilter(Collection<String> itemClassFilter) {
        if (itemClassFilter == null) {
            this.itemClassFilter = null;
            return;
        }
        this.itemClassFilter = new ArrayList<String>(itemClassFilter);
    }

    public ListCatalogItemsRequest withItemClassFilter(String ... itemClassFilter) {
        if (this.itemClassFilter == null) {
            this.setItemClassFilter(new ArrayList<String>(itemClassFilter.length));
        }
        for (String ele : itemClassFilter) {
            this.itemClassFilter.add(ele);
        }
        return this;
    }

    public ListCatalogItemsRequest withItemClassFilter(Collection<String> itemClassFilter) {
        this.setItemClassFilter(itemClassFilter);
        return this;
    }

    public ListCatalogItemsRequest withItemClassFilter(CatalogItemClass ... itemClassFilter) {
        ArrayList<String> itemClassFilterCopy = new ArrayList<String>(itemClassFilter.length);
        for (CatalogItemClass value : itemClassFilter) {
            itemClassFilterCopy.add(value.toString());
        }
        if (this.getItemClassFilter() == null) {
            this.setItemClassFilter(itemClassFilterCopy);
        } else {
            this.getItemClassFilter().addAll(itemClassFilterCopy);
        }
        return this;
    }

    public List<String> getSupportedStorageFilter() {
        return this.supportedStorageFilter;
    }

    public void setSupportedStorageFilter(Collection<String> supportedStorageFilter) {
        if (supportedStorageFilter == null) {
            this.supportedStorageFilter = null;
            return;
        }
        this.supportedStorageFilter = new ArrayList<String>(supportedStorageFilter);
    }

    public ListCatalogItemsRequest withSupportedStorageFilter(String ... supportedStorageFilter) {
        if (this.supportedStorageFilter == null) {
            this.setSupportedStorageFilter(new ArrayList<String>(supportedStorageFilter.length));
        }
        for (String ele : supportedStorageFilter) {
            this.supportedStorageFilter.add(ele);
        }
        return this;
    }

    public ListCatalogItemsRequest withSupportedStorageFilter(Collection<String> supportedStorageFilter) {
        this.setSupportedStorageFilter(supportedStorageFilter);
        return this;
    }

    public ListCatalogItemsRequest withSupportedStorageFilter(SupportedStorageEnum ... supportedStorageFilter) {
        ArrayList<String> supportedStorageFilterCopy = new ArrayList<String>(supportedStorageFilter.length);
        for (SupportedStorageEnum value : supportedStorageFilter) {
            supportedStorageFilterCopy.add(value.toString());
        }
        if (this.getSupportedStorageFilter() == null) {
            this.setSupportedStorageFilter(supportedStorageFilterCopy);
        } else {
            this.getSupportedStorageFilter().addAll(supportedStorageFilterCopy);
        }
        return this;
    }

    public List<String> getEC2FamilyFilter() {
        return this.eC2FamilyFilter;
    }

    public void setEC2FamilyFilter(Collection<String> eC2FamilyFilter) {
        if (eC2FamilyFilter == null) {
            this.eC2FamilyFilter = null;
            return;
        }
        this.eC2FamilyFilter = new ArrayList<String>(eC2FamilyFilter);
    }

    public ListCatalogItemsRequest withEC2FamilyFilter(String ... eC2FamilyFilter) {
        if (this.eC2FamilyFilter == null) {
            this.setEC2FamilyFilter(new ArrayList<String>(eC2FamilyFilter.length));
        }
        for (String ele : eC2FamilyFilter) {
            this.eC2FamilyFilter.add(ele);
        }
        return this;
    }

    public ListCatalogItemsRequest withEC2FamilyFilter(Collection<String> eC2FamilyFilter) {
        this.setEC2FamilyFilter(eC2FamilyFilter);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getItemClassFilter() != null) {
            sb.append("ItemClassFilter: ").append(this.getItemClassFilter()).append(",");
        }
        if (this.getSupportedStorageFilter() != null) {
            sb.append("SupportedStorageFilter: ").append(this.getSupportedStorageFilter()).append(",");
        }
        if (this.getEC2FamilyFilter() != null) {
            sb.append("EC2FamilyFilter: ").append(this.getEC2FamilyFilter());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCatalogItemsRequest)) {
            return false;
        }
        ListCatalogItemsRequest other = (ListCatalogItemsRequest)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getItemClassFilter() == null ^ this.getItemClassFilter() == null) {
            return false;
        }
        if (other.getItemClassFilter() != null && !other.getItemClassFilter().equals(this.getItemClassFilter())) {
            return false;
        }
        if (other.getSupportedStorageFilter() == null ^ this.getSupportedStorageFilter() == null) {
            return false;
        }
        if (other.getSupportedStorageFilter() != null && !other.getSupportedStorageFilter().equals(this.getSupportedStorageFilter())) {
            return false;
        }
        if (other.getEC2FamilyFilter() == null ^ this.getEC2FamilyFilter() == null) {
            return false;
        }
        return other.getEC2FamilyFilter() == null || other.getEC2FamilyFilter().equals(this.getEC2FamilyFilter());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getItemClassFilter() == null ? 0 : this.getItemClassFilter().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedStorageFilter() == null ? 0 : this.getSupportedStorageFilter().hashCode());
        hashCode = 31 * hashCode + (this.getEC2FamilyFilter() == null ? 0 : this.getEC2FamilyFilter().hashCode());
        return hashCode;
    }

    public ListCatalogItemsRequest clone() {
        return (ListCatalogItemsRequest)super.clone();
    }
}

