/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.organizations.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/CreateGovCloudAccount"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateGovCloudAccountRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies the email address of the owner to assign to the new member account in the commercial Region. This email
     * address must not already be associated with another Amazon Web Services account. You must use a valid email
     * address to complete account creation.
     * </p>
     * <p>
     * The rules for a valid email address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The address must be a minimum of 6 and a maximum of 64 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * All characters must be 7-bit ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * There must be one and only one @ symbol, which separates the local name from the domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't contain any of the following characters:
     * </p>
     * <p>
     * whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't begin with a dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can't begin or end with a hyphen (-) or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name must contain at least one dot
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't access the root user of the account or remove an account that was created with an invalid email
     * address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address
     * for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web
     * Services GovCloud (US) Region.
     * </p>
     */
    private String email;
    /**
     * <p>
     * The friendly name of the member account.
     * </p>
     * <p>
     * The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't separate
     * characters with a dash (–).
     * </p>
     */
    private String accountName;
    /**
     * <p>
     * (Optional)
     * </p>
     * <p>
     * The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the
     * Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account,
     * allowing users in the management account to assume the role, as permitted by the management account
     * administrator. The role has administrator permissions in the new member account.
     * </p>
     * <p>
     * If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     * </p>
     * <p>
     * For more information about how to use this role to access the member account, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     * >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i>
     * and steps 2 and 3 in <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate
     * Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The
     * pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following
     * characters: =,.@-
     * </p>
     */
    private String roleName;
    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost
     * Management User Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     */
    private String iamUserAccessToBilling;
    /**
     * <p>
     * A list of tags that you want to attach to the newly created account. These tags are attached to the commercial
     * account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual
     * GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account
     * exists.
     * </p>
     * <p>
     * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string,
     * but you can't set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account, then the
     * entire request fails and the account is not created.
     * </p>
     * </note>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * Specifies the email address of the owner to assign to the new member account in the commercial Region. This email
     * address must not already be associated with another Amazon Web Services account. You must use a valid email
     * address to complete account creation.
     * </p>
     * <p>
     * The rules for a valid email address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The address must be a minimum of 6 and a maximum of 64 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * All characters must be 7-bit ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * There must be one and only one @ symbol, which separates the local name from the domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't contain any of the following characters:
     * </p>
     * <p>
     * whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't begin with a dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can't begin or end with a hyphen (-) or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name must contain at least one dot
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't access the root user of the account or remove an account that was created with an invalid email
     * address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address
     * for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web
     * Services GovCloud (US) Region.
     * </p>
     * 
     * @param email
     *        Specifies the email address of the owner to assign to the new member account in the commercial Region.
     *        This email address must not already be associated with another Amazon Web Services account. You must use a
     *        valid email address to complete account creation.</p>
     *        <p>
     *        The rules for a valid email address:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        The address must be a minimum of 6 and a maximum of 64 characters long.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        All characters must be 7-bit ASCII characters.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        There must be one and only one @ symbol, which separates the local name from the domain name.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The local name can't contain any of the following characters:
     *        </p>
     *        <p>
     *        whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The local name can't begin with a dot (.)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The domain name can't begin or end with a hyphen (-) or dot (.)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The domain name must contain at least one dot
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        You can't access the root user of the account or remove an account that was created with an invalid email
     *        address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email
     *        address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from
     *        the Amazon Web Services GovCloud (US) Region.
     */

    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * <p>
     * Specifies the email address of the owner to assign to the new member account in the commercial Region. This email
     * address must not already be associated with another Amazon Web Services account. You must use a valid email
     * address to complete account creation.
     * </p>
     * <p>
     * The rules for a valid email address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The address must be a minimum of 6 and a maximum of 64 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * All characters must be 7-bit ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * There must be one and only one @ symbol, which separates the local name from the domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't contain any of the following characters:
     * </p>
     * <p>
     * whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't begin with a dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can't begin or end with a hyphen (-) or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name must contain at least one dot
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't access the root user of the account or remove an account that was created with an invalid email
     * address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address
     * for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web
     * Services GovCloud (US) Region.
     * </p>
     * 
     * @return Specifies the email address of the owner to assign to the new member account in the commercial Region.
     *         This email address must not already be associated with another Amazon Web Services account. You must use
     *         a valid email address to complete account creation.</p>
     *         <p>
     *         The rules for a valid email address:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The address must be a minimum of 6 and a maximum of 64 characters long.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All characters must be 7-bit ASCII characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There must be one and only one @ symbol, which separates the local name from the domain name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The local name can't contain any of the following characters:
     *         </p>
     *         <p>
     *         whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The local name can't begin with a dot (.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The domain name can't begin or end with a hyphen (-) or dot (.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The domain name must contain at least one dot
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can't access the root user of the account or remove an account that was created with an invalid email
     *         address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email
     *         address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from
     *         the Amazon Web Services GovCloud (US) Region.
     */

    public String getEmail() {
        return this.email;
    }

    /**
     * <p>
     * Specifies the email address of the owner to assign to the new member account in the commercial Region. This email
     * address must not already be associated with another Amazon Web Services account. You must use a valid email
     * address to complete account creation.
     * </p>
     * <p>
     * The rules for a valid email address:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The address must be a minimum of 6 and a maximum of 64 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * All characters must be 7-bit ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * There must be one and only one @ symbol, which separates the local name from the domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't contain any of the following characters:
     * </p>
     * <p>
     * whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     * </p>
     * </li>
     * <li>
     * <p>
     * The local name can't begin with a dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name can't begin or end with a hyphen (-) or dot (.)
     * </p>
     * </li>
     * <li>
     * <p>
     * The domain name must contain at least one dot
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't access the root user of the account or remove an account that was created with an invalid email
     * address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email address
     * for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from the Amazon Web
     * Services GovCloud (US) Region.
     * </p>
     * 
     * @param email
     *        Specifies the email address of the owner to assign to the new member account in the commercial Region.
     *        This email address must not already be associated with another Amazon Web Services account. You must use a
     *        valid email address to complete account creation.</p>
     *        <p>
     *        The rules for a valid email address:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        The address must be a minimum of 6 and a maximum of 64 characters long.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        All characters must be 7-bit ASCII characters.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        There must be one and only one @ symbol, which separates the local name from the domain name.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The local name can't contain any of the following characters:
     *        </p>
     *        <p>
     *        whitespace, " ' ( ) &lt; &gt; [ ] : ; , \ | % &amp;
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The local name can't begin with a dot (.)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The domain name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The domain name can't begin or end with a hyphen (-) or dot (.)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The domain name must contain at least one dot
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        You can't access the root user of the account or remove an account that was created with an invalid email
     *        address. Like all request parameters for <code>CreateGovCloudAccount</code>, the request for the email
     *        address for the Amazon Web Services GovCloud (US) account originates from the commercial Region, not from
     *        the Amazon Web Services GovCloud (US) Region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateGovCloudAccountRequest withEmail(String email) {
        setEmail(email);
        return this;
    }

    /**
     * <p>
     * The friendly name of the member account.
     * </p>
     * <p>
     * The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't separate
     * characters with a dash (–).
     * </p>
     * 
     * @param accountName
     *        The friendly name of the member account. </p>
     *        <p>
     *        The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't
     *        separate characters with a dash (–).
     */

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    /**
     * <p>
     * The friendly name of the member account.
     * </p>
     * <p>
     * The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't separate
     * characters with a dash (–).
     * </p>
     * 
     * @return The friendly name of the member account. </p>
     *         <p>
     *         The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't
     *         separate characters with a dash (–).
     */

    public String getAccountName() {
        return this.accountName;
    }

    /**
     * <p>
     * The friendly name of the member account.
     * </p>
     * <p>
     * The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't separate
     * characters with a dash (–).
     * </p>
     * 
     * @param accountName
     *        The friendly name of the member account. </p>
     *        <p>
     *        The account name can consist of only the characters [a-z],[A-Z],[0-9], hyphen (-), or dot (.) You can't
     *        separate characters with a dash (–).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateGovCloudAccountRequest withAccountName(String accountName) {
        setAccountName(accountName);
        return this;
    }

    /**
     * <p>
     * (Optional)
     * </p>
     * <p>
     * The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the
     * Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account,
     * allowing users in the management account to assume the role, as permitted by the management account
     * administrator. The role has administrator permissions in the new member account.
     * </p>
     * <p>
     * If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     * </p>
     * <p>
     * For more information about how to use this role to access the member account, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     * >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i>
     * and steps 2 and 3 in <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate
     * Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The
     * pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following
     * characters: =,.@-
     * </p>
     * 
     * @param roleName
     *        (Optional)</p>
     *        <p>
     *        The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both
     *        the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management
     *        account, allowing users in the management account to assume the role, as permitted by the management
     *        account administrator. The role has administrator permissions in the new member account.
     *        </p>
     *        <p>
     *        If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     *        </p>
     *        <p>
     *        For more information about how to use this role to access the member account, see <a href=
     *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     *        >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User
     *        Guide</i> and steps 2 and 3 in <a
     *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
     *        Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     *        </p>
     *        <p>
     *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter.
     *        The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the
     *        following characters: =,.@-
     */

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    /**
     * <p>
     * (Optional)
     * </p>
     * <p>
     * The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the
     * Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account,
     * allowing users in the management account to assume the role, as permitted by the management account
     * administrator. The role has administrator permissions in the new member account.
     * </p>
     * <p>
     * If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     * </p>
     * <p>
     * For more information about how to use this role to access the member account, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     * >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i>
     * and steps 2 and 3 in <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate
     * Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The
     * pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following
     * characters: =,.@-
     * </p>
     * 
     * @return (Optional)</p>
     *         <p>
     *         The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both
     *         the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the
     *         management account, allowing users in the management account to assume the role, as permitted by the
     *         management account administrator. The role has administrator permissions in the new member account.
     *         </p>
     *         <p>
     *         If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>
     *         .
     *         </p>
     *         <p>
     *         For more information about how to use this role to access the member account, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     *         >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User
     *         Guide</i> and steps 2 and 3 in <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
     *         Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     *         </p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter.
     *         The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the
     *         following characters: =,.@-
     */

    public String getRoleName() {
        return this.roleName;
    }

    /**
     * <p>
     * (Optional)
     * </p>
     * <p>
     * The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both the
     * Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management account,
     * allowing users in the management account to assume the role, as permitted by the management account
     * administrator. The role has administrator permissions in the new member account.
     * </p>
     * <p>
     * If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     * </p>
     * <p>
     * For more information about how to use this role to access the member account, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     * >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User Guide</i>
     * and steps 2 and 3 in <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial: Delegate
     * Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter. The
     * pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the following
     * characters: =,.@-
     * </p>
     * 
     * @param roleName
     *        (Optional)</p>
     *        <p>
     *        The name of an IAM role that Organizations automatically preconfigures in the new member accounts in both
     *        the Amazon Web Services GovCloud (US) Region and in the commercial Region. This role trusts the management
     *        account, allowing users in the management account to assume the role, as permitted by the management
     *        account administrator. The role has administrator permissions in the new member account.
     *        </p>
     *        <p>
     *        If you don't specify this parameter, the role name defaults to <code>OrganizationAccountAccessRole</code>.
     *        </p>
     *        <p>
     *        For more information about how to use this role to access the member account, see <a href=
     *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role"
     *        >Accessing and Administering the Member Accounts in Your Organization</a> in the <i>Organizations User
     *        Guide</i> and steps 2 and 3 in <a
     *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html">Tutorial:
     *        Delegate Access Across Amazon Web Services accounts Using IAM Roles</a> in the <i>IAM User Guide.</i>
     *        </p>
     *        <p>
     *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter.
     *        The pattern can include uppercase letters, lowercase letters, digits with no spaces, and any of the
     *        following characters: =,.@-
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateGovCloudAccountRequest withRoleName(String roleName) {
        setRoleName(roleName);
        return this;
    }

    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost
     * Management User Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     * 
     * @param iamUserAccessToBilling
     *        If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
     *        account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>,
     *        only the root user of the new account can access account billing information. For more information, see <a
     *        href=
     *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     *        >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing
     *        and Cost Management User Guide.</i> </p>
     *        <p>
     *        If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
     *        with the required permissions can access billing information for the new account.
     * @see IAMUserAccessToBilling
     */

    public void setIamUserAccessToBilling(String iamUserAccessToBilling) {
        this.iamUserAccessToBilling = iamUserAccessToBilling;
    }

    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost
     * Management User Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     * 
     * @return If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
     *         account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>,
     *         only the root user of the new account can access account billing information. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     *         >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing
     *         and Cost Management User Guide.</i> </p>
     *         <p>
     *         If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
     *         with the required permissions can access billing information for the new account.
     * @see IAMUserAccessToBilling
     */

    public String getIamUserAccessToBilling() {
        return this.iamUserAccessToBilling;
    }

    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost
     * Management User Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     * 
     * @param iamUserAccessToBilling
     *        If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
     *        account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>,
     *        only the root user of the new account can access account billing information. For more information, see <a
     *        href=
     *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     *        >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing
     *        and Cost Management User Guide.</i> </p>
     *        <p>
     *        If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
     *        with the required permissions can access billing information for the new account.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IAMUserAccessToBilling
     */

    public CreateGovCloudAccountRequest withIamUserAccessToBilling(String iamUserAccessToBilling) {
        setIamUserAccessToBilling(iamUserAccessToBilling);
        return this;
    }

    /**
     * <p>
     * If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access account
     * billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>, only the root user
     * of the new account can access account billing information. For more information, see <a href=
     * "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     * >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing and Cost
     * Management User Guide.</i>
     * </p>
     * <p>
     * If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles with the
     * required permissions can access billing information for the new account.
     * </p>
     * 
     * @param iamUserAccessToBilling
     *        If set to <code>ALLOW</code>, the new linked account in the commercial Region enables IAM users to access
     *        account billing information <i>if</i> they have the required permissions. If set to <code>DENY</code>,
     *        only the root user of the new account can access account billing information. For more information, see <a
     *        href=
     *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/grantaccess.html#ControllingAccessWebsite-Activate"
     *        >Activating Access to the Billing and Cost Management Console</a> in the <i>Amazon Web Services Billing
     *        and Cost Management User Guide.</i> </p>
     *        <p>
     *        If you don't specify this parameter, the value defaults to <code>ALLOW</code>, and IAM users and roles
     *        with the required permissions can access billing information for the new account.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IAMUserAccessToBilling
     */

    public CreateGovCloudAccountRequest withIamUserAccessToBilling(IAMUserAccessToBilling iamUserAccessToBilling) {
        this.iamUserAccessToBilling = iamUserAccessToBilling.toString();
        return this;
    }

    /**
     * <p>
     * A list of tags that you want to attach to the newly created account. These tags are attached to the commercial
     * account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual
     * GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account
     * exists.
     * </p>
     * <p>
     * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string,
     * but you can't set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account, then the
     * entire request fails and the account is not created.
     * </p>
     * </note>
     * 
     * @return A list of tags that you want to attach to the newly created account. These tags are attached to the
     *         commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add
     *         tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after
     *         the new GovCloud account exists.</p>
     *         <p>
     *         For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
     *         string, but you can't set it to <code>null</code>. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     *         resources</a> in the Organizations User Guide.
     *         </p>
     *         <note>
     *         <p>
     *         If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account,
     *         then the entire request fails and the account is not created.
     *         </p>
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * A list of tags that you want to attach to the newly created account. These tags are attached to the commercial
     * account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual
     * GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account
     * exists.
     * </p>
     * <p>
     * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string,
     * but you can't set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account, then the
     * entire request fails and the account is not created.
     * </p>
     * </note>
     * 
     * @param tags
     *        A list of tags that you want to attach to the newly created account. These tags are attached to the
     *        commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add
     *        tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after
     *        the new GovCloud account exists.</p>
     *        <p>
     *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
     *        string, but you can't set it to <code>null</code>. For more information about tagging, see <a
     *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     *        resources</a> in the Organizations User Guide.
     *        </p>
     *        <note>
     *        <p>
     *        If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account,
     *        then the entire request fails and the account is not created.
     *        </p>
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * A list of tags that you want to attach to the newly created account. These tags are attached to the commercial
     * account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual
     * GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account
     * exists.
     * </p>
     * <p>
     * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string,
     * but you can't set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account, then the
     * entire request fails and the account is not created.
     * </p>
     * </note>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of tags that you want to attach to the newly created account. These tags are attached to the
     *        commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add
     *        tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after
     *        the new GovCloud account exists.</p>
     *        <p>
     *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
     *        string, but you can't set it to <code>null</code>. For more information about tagging, see <a
     *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     *        resources</a> in the Organizations User Guide.
     *        </p>
     *        <note>
     *        <p>
     *        If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account,
     *        then the entire request fails and the account is not created.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateGovCloudAccountRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of tags that you want to attach to the newly created account. These tags are attached to the commercial
     * account associated with the GovCloud account, and not to the GovCloud account itself. To add tags to the actual
     * GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after the new GovCloud account
     * exists.
     * </p>
     * <p>
     * For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty string,
     * but you can't set it to <code>null</code>. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     * resources</a> in the Organizations User Guide.
     * </p>
     * <note>
     * <p>
     * If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account, then the
     * entire request fails and the account is not created.
     * </p>
     * </note>
     * 
     * @param tags
     *        A list of tags that you want to attach to the newly created account. These tags are attached to the
     *        commercial account associated with the GovCloud account, and not to the GovCloud account itself. To add
     *        tags to the actual GovCloud account, call the <a>TagResource</a> operation in the GovCloud region after
     *        the new GovCloud account exists.</p>
     *        <p>
     *        For each tag in the list, you must specify both a tag key and a value. You can set the value to an empty
     *        string, but you can't set it to <code>null</code>. For more information about tagging, see <a
     *        href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html">Tagging Organizations
     *        resources</a> in the Organizations User Guide.
     *        </p>
     *        <note>
     *        <p>
     *        If any one of the tags is not valid or if you exceed the maximum allowed number of tags for an account,
     *        then the entire request fails and the account is not created.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateGovCloudAccountRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEmail() != null)
            sb.append("Email: ").append("***Sensitive Data Redacted***").append(",");
        if (getAccountName() != null)
            sb.append("AccountName: ").append("***Sensitive Data Redacted***").append(",");
        if (getRoleName() != null)
            sb.append("RoleName: ").append(getRoleName()).append(",");
        if (getIamUserAccessToBilling() != null)
            sb.append("IamUserAccessToBilling: ").append(getIamUserAccessToBilling()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateGovCloudAccountRequest == false)
            return false;
        CreateGovCloudAccountRequest other = (CreateGovCloudAccountRequest) obj;
        if (other.getEmail() == null ^ this.getEmail() == null)
            return false;
        if (other.getEmail() != null && other.getEmail().equals(this.getEmail()) == false)
            return false;
        if (other.getAccountName() == null ^ this.getAccountName() == null)
            return false;
        if (other.getAccountName() != null && other.getAccountName().equals(this.getAccountName()) == false)
            return false;
        if (other.getRoleName() == null ^ this.getRoleName() == null)
            return false;
        if (other.getRoleName() != null && other.getRoleName().equals(this.getRoleName()) == false)
            return false;
        if (other.getIamUserAccessToBilling() == null ^ this.getIamUserAccessToBilling() == null)
            return false;
        if (other.getIamUserAccessToBilling() != null && other.getIamUserAccessToBilling().equals(this.getIamUserAccessToBilling()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEmail() == null) ? 0 : getEmail().hashCode());
        hashCode = prime * hashCode + ((getAccountName() == null) ? 0 : getAccountName().hashCode());
        hashCode = prime * hashCode + ((getRoleName() == null) ? 0 : getRoleName().hashCode());
        hashCode = prime * hashCode + ((getIamUserAccessToBilling() == null) ? 0 : getIamUserAccessToBilling().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateGovCloudAccountRequest clone() {
        return (CreateGovCloudAccountRequest) super.clone();
    }

}
