/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opsworks.model.RaidArray;

@SdkInternalApi
public class RaidArrayMarshaller {
    private static final MarshallingInfo<String> RAIDARRAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidArrayId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Integer> RAIDLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidLevel").build();
    private static final MarshallingInfo<Integer> NUMBEROFDISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDisks").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").build();
    private static final MarshallingInfo<String> MOUNTPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountPoint").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();
    private static final RaidArrayMarshaller instance = new RaidArrayMarshaller();

    public static RaidArrayMarshaller getInstance() {
        return instance;
    }

    public void marshall(RaidArray raidArray, ProtocolMarshaller protocolMarshaller) {
        if (raidArray == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)raidArray.getRaidArrayId(), RAIDARRAYID_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getInstanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getRaidLevel(), RAIDLEVEL_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getNumberOfDisks(), NUMBEROFDISKS_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getSize(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getDevice(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getMountPoint(), MOUNTPOINT_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getStackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getVolumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)raidArray.getIops(), IOPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

