/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.UpgradeStatus;
import com.amazonaws.services.opensearch.model.UpgradeStep;
import com.amazonaws.services.opensearch.model.transform.UpgradeStepItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpgradeStepItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String upgradeStep;
    private String upgradeStepStatus;
    private List<String> issues;
    private Double progressPercent;

    public void setUpgradeStep(String upgradeStep) {
        this.upgradeStep = upgradeStep;
    }

    public String getUpgradeStep() {
        return this.upgradeStep;
    }

    public UpgradeStepItem withUpgradeStep(String upgradeStep) {
        this.setUpgradeStep(upgradeStep);
        return this;
    }

    public UpgradeStepItem withUpgradeStep(UpgradeStep upgradeStep) {
        this.upgradeStep = upgradeStep.toString();
        return this;
    }

    public void setUpgradeStepStatus(String upgradeStepStatus) {
        this.upgradeStepStatus = upgradeStepStatus;
    }

    public String getUpgradeStepStatus() {
        return this.upgradeStepStatus;
    }

    public UpgradeStepItem withUpgradeStepStatus(String upgradeStepStatus) {
        this.setUpgradeStepStatus(upgradeStepStatus);
        return this;
    }

    public UpgradeStepItem withUpgradeStepStatus(UpgradeStatus upgradeStepStatus) {
        this.upgradeStepStatus = upgradeStepStatus.toString();
        return this;
    }

    public List<String> getIssues() {
        return this.issues;
    }

    public void setIssues(Collection<String> issues) {
        if (issues == null) {
            this.issues = null;
            return;
        }
        this.issues = new ArrayList<String>(issues);
    }

    public UpgradeStepItem withIssues(String ... issues) {
        if (this.issues == null) {
            this.setIssues(new ArrayList<String>(issues.length));
        }
        for (String ele : issues) {
            this.issues.add(ele);
        }
        return this;
    }

    public UpgradeStepItem withIssues(Collection<String> issues) {
        this.setIssues(issues);
        return this;
    }

    public void setProgressPercent(Double progressPercent) {
        this.progressPercent = progressPercent;
    }

    public Double getProgressPercent() {
        return this.progressPercent;
    }

    public UpgradeStepItem withProgressPercent(Double progressPercent) {
        this.setProgressPercent(progressPercent);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUpgradeStep() != null) {
            sb.append("UpgradeStep: ").append(this.getUpgradeStep()).append(",");
        }
        if (this.getUpgradeStepStatus() != null) {
            sb.append("UpgradeStepStatus: ").append(this.getUpgradeStepStatus()).append(",");
        }
        if (this.getIssues() != null) {
            sb.append("Issues: ").append(this.getIssues()).append(",");
        }
        if (this.getProgressPercent() != null) {
            sb.append("ProgressPercent: ").append(this.getProgressPercent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeStepItem)) {
            return false;
        }
        UpgradeStepItem other = (UpgradeStepItem)obj;
        if (other.getUpgradeStep() == null ^ this.getUpgradeStep() == null) {
            return false;
        }
        if (other.getUpgradeStep() != null && !other.getUpgradeStep().equals(this.getUpgradeStep())) {
            return false;
        }
        if (other.getUpgradeStepStatus() == null ^ this.getUpgradeStepStatus() == null) {
            return false;
        }
        if (other.getUpgradeStepStatus() != null && !other.getUpgradeStepStatus().equals(this.getUpgradeStepStatus())) {
            return false;
        }
        if (other.getIssues() == null ^ this.getIssues() == null) {
            return false;
        }
        if (other.getIssues() != null && !other.getIssues().equals(this.getIssues())) {
            return false;
        }
        if (other.getProgressPercent() == null ^ this.getProgressPercent() == null) {
            return false;
        }
        return other.getProgressPercent() == null || other.getProgressPercent().equals(this.getProgressPercent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUpgradeStep() == null ? 0 : this.getUpgradeStep().hashCode());
        hashCode = 31 * hashCode + (this.getUpgradeStepStatus() == null ? 0 : this.getUpgradeStepStatus().hashCode());
        hashCode = 31 * hashCode + (this.getIssues() == null ? 0 : this.getIssues().hashCode());
        hashCode = 31 * hashCode + (this.getProgressPercent() == null ? 0 : this.getProgressPercent().hashCode());
        return hashCode;
    }

    public UpgradeStepItem clone() {
        try {
            return (UpgradeStepItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpgradeStepItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

