/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.opensearch.AmazonOpenSearchAsync;
import com.amazonaws.services.opensearch.AmazonOpenSearchAsyncClientBuilder;
import com.amazonaws.services.opensearch.AmazonOpenSearchClient;
import com.amazonaws.services.opensearch.model.AcceptInboundConnectionRequest;
import com.amazonaws.services.opensearch.model.AcceptInboundConnectionResult;
import com.amazonaws.services.opensearch.model.AddTagsRequest;
import com.amazonaws.services.opensearch.model.AddTagsResult;
import com.amazonaws.services.opensearch.model.AssociatePackageRequest;
import com.amazonaws.services.opensearch.model.AssociatePackageResult;
import com.amazonaws.services.opensearch.model.AuthorizeVpcEndpointAccessRequest;
import com.amazonaws.services.opensearch.model.AuthorizeVpcEndpointAccessResult;
import com.amazonaws.services.opensearch.model.CancelServiceSoftwareUpdateRequest;
import com.amazonaws.services.opensearch.model.CancelServiceSoftwareUpdateResult;
import com.amazonaws.services.opensearch.model.CreateDomainRequest;
import com.amazonaws.services.opensearch.model.CreateDomainResult;
import com.amazonaws.services.opensearch.model.CreateOutboundConnectionRequest;
import com.amazonaws.services.opensearch.model.CreateOutboundConnectionResult;
import com.amazonaws.services.opensearch.model.CreatePackageRequest;
import com.amazonaws.services.opensearch.model.CreatePackageResult;
import com.amazonaws.services.opensearch.model.CreateVpcEndpointRequest;
import com.amazonaws.services.opensearch.model.CreateVpcEndpointResult;
import com.amazonaws.services.opensearch.model.DeleteDomainRequest;
import com.amazonaws.services.opensearch.model.DeleteDomainResult;
import com.amazonaws.services.opensearch.model.DeleteInboundConnectionRequest;
import com.amazonaws.services.opensearch.model.DeleteInboundConnectionResult;
import com.amazonaws.services.opensearch.model.DeleteOutboundConnectionRequest;
import com.amazonaws.services.opensearch.model.DeleteOutboundConnectionResult;
import com.amazonaws.services.opensearch.model.DeletePackageRequest;
import com.amazonaws.services.opensearch.model.DeletePackageResult;
import com.amazonaws.services.opensearch.model.DeleteVpcEndpointRequest;
import com.amazonaws.services.opensearch.model.DeleteVpcEndpointResult;
import com.amazonaws.services.opensearch.model.DescribeDomainAutoTunesRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainAutoTunesResult;
import com.amazonaws.services.opensearch.model.DescribeDomainChangeProgressRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainChangeProgressResult;
import com.amazonaws.services.opensearch.model.DescribeDomainConfigRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainConfigResult;
import com.amazonaws.services.opensearch.model.DescribeDomainHealthRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainHealthResult;
import com.amazonaws.services.opensearch.model.DescribeDomainNodesRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainNodesResult;
import com.amazonaws.services.opensearch.model.DescribeDomainRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainResult;
import com.amazonaws.services.opensearch.model.DescribeDomainsRequest;
import com.amazonaws.services.opensearch.model.DescribeDomainsResult;
import com.amazonaws.services.opensearch.model.DescribeDryRunProgressRequest;
import com.amazonaws.services.opensearch.model.DescribeDryRunProgressResult;
import com.amazonaws.services.opensearch.model.DescribeInboundConnectionsRequest;
import com.amazonaws.services.opensearch.model.DescribeInboundConnectionsResult;
import com.amazonaws.services.opensearch.model.DescribeInstanceTypeLimitsRequest;
import com.amazonaws.services.opensearch.model.DescribeInstanceTypeLimitsResult;
import com.amazonaws.services.opensearch.model.DescribeOutboundConnectionsRequest;
import com.amazonaws.services.opensearch.model.DescribeOutboundConnectionsResult;
import com.amazonaws.services.opensearch.model.DescribePackagesRequest;
import com.amazonaws.services.opensearch.model.DescribePackagesResult;
import com.amazonaws.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import com.amazonaws.services.opensearch.model.DescribeReservedInstanceOfferingsResult;
import com.amazonaws.services.opensearch.model.DescribeReservedInstancesRequest;
import com.amazonaws.services.opensearch.model.DescribeReservedInstancesResult;
import com.amazonaws.services.opensearch.model.DescribeVpcEndpointsRequest;
import com.amazonaws.services.opensearch.model.DescribeVpcEndpointsResult;
import com.amazonaws.services.opensearch.model.DissociatePackageRequest;
import com.amazonaws.services.opensearch.model.DissociatePackageResult;
import com.amazonaws.services.opensearch.model.GetCompatibleVersionsRequest;
import com.amazonaws.services.opensearch.model.GetCompatibleVersionsResult;
import com.amazonaws.services.opensearch.model.GetPackageVersionHistoryRequest;
import com.amazonaws.services.opensearch.model.GetPackageVersionHistoryResult;
import com.amazonaws.services.opensearch.model.GetUpgradeHistoryRequest;
import com.amazonaws.services.opensearch.model.GetUpgradeHistoryResult;
import com.amazonaws.services.opensearch.model.GetUpgradeStatusRequest;
import com.amazonaws.services.opensearch.model.GetUpgradeStatusResult;
import com.amazonaws.services.opensearch.model.ListDomainNamesRequest;
import com.amazonaws.services.opensearch.model.ListDomainNamesResult;
import com.amazonaws.services.opensearch.model.ListDomainsForPackageRequest;
import com.amazonaws.services.opensearch.model.ListDomainsForPackageResult;
import com.amazonaws.services.opensearch.model.ListInstanceTypeDetailsRequest;
import com.amazonaws.services.opensearch.model.ListInstanceTypeDetailsResult;
import com.amazonaws.services.opensearch.model.ListPackagesForDomainRequest;
import com.amazonaws.services.opensearch.model.ListPackagesForDomainResult;
import com.amazonaws.services.opensearch.model.ListScheduledActionsRequest;
import com.amazonaws.services.opensearch.model.ListScheduledActionsResult;
import com.amazonaws.services.opensearch.model.ListTagsRequest;
import com.amazonaws.services.opensearch.model.ListTagsResult;
import com.amazonaws.services.opensearch.model.ListVersionsRequest;
import com.amazonaws.services.opensearch.model.ListVersionsResult;
import com.amazonaws.services.opensearch.model.ListVpcEndpointAccessRequest;
import com.amazonaws.services.opensearch.model.ListVpcEndpointAccessResult;
import com.amazonaws.services.opensearch.model.ListVpcEndpointsForDomainRequest;
import com.amazonaws.services.opensearch.model.ListVpcEndpointsForDomainResult;
import com.amazonaws.services.opensearch.model.ListVpcEndpointsRequest;
import com.amazonaws.services.opensearch.model.ListVpcEndpointsResult;
import com.amazonaws.services.opensearch.model.PurchaseReservedInstanceOfferingRequest;
import com.amazonaws.services.opensearch.model.PurchaseReservedInstanceOfferingResult;
import com.amazonaws.services.opensearch.model.RejectInboundConnectionRequest;
import com.amazonaws.services.opensearch.model.RejectInboundConnectionResult;
import com.amazonaws.services.opensearch.model.RemoveTagsRequest;
import com.amazonaws.services.opensearch.model.RemoveTagsResult;
import com.amazonaws.services.opensearch.model.RevokeVpcEndpointAccessRequest;
import com.amazonaws.services.opensearch.model.RevokeVpcEndpointAccessResult;
import com.amazonaws.services.opensearch.model.StartServiceSoftwareUpdateRequest;
import com.amazonaws.services.opensearch.model.StartServiceSoftwareUpdateResult;
import com.amazonaws.services.opensearch.model.UpdateDomainConfigRequest;
import com.amazonaws.services.opensearch.model.UpdateDomainConfigResult;
import com.amazonaws.services.opensearch.model.UpdatePackageRequest;
import com.amazonaws.services.opensearch.model.UpdatePackageResult;
import com.amazonaws.services.opensearch.model.UpdateScheduledActionRequest;
import com.amazonaws.services.opensearch.model.UpdateScheduledActionResult;
import com.amazonaws.services.opensearch.model.UpdateVpcEndpointRequest;
import com.amazonaws.services.opensearch.model.UpdateVpcEndpointResult;
import com.amazonaws.services.opensearch.model.UpgradeDomainRequest;
import com.amazonaws.services.opensearch.model.UpgradeDomainResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonOpenSearchAsyncClient
extends AmazonOpenSearchClient
implements AmazonOpenSearchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonOpenSearchAsyncClientBuilder asyncBuilder() {
        return AmazonOpenSearchAsyncClientBuilder.standard();
    }

    AmazonOpenSearchAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonOpenSearchAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptInboundConnectionResult> acceptInboundConnectionAsync(AcceptInboundConnectionRequest request) {
        return this.acceptInboundConnectionAsync(request, null);
    }

    @Override
    public Future<AcceptInboundConnectionResult> acceptInboundConnectionAsync(AcceptInboundConnectionRequest request, final AsyncHandler<AcceptInboundConnectionRequest, AcceptInboundConnectionResult> asyncHandler) {
        final AcceptInboundConnectionRequest finalRequest = (AcceptInboundConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptInboundConnectionResult>(){

            @Override
            public AcceptInboundConnectionResult call() throws Exception {
                AcceptInboundConnectionResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeAcceptInboundConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request) {
        return this.addTagsAsync(request, null);
    }

    @Override
    public Future<AddTagsResult> addTagsAsync(AddTagsRequest request, final AsyncHandler<AddTagsRequest, AddTagsResult> asyncHandler) {
        final AddTagsRequest finalRequest = (AddTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsResult>(){

            @Override
            public AddTagsResult call() throws Exception {
                AddTagsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeAddTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociatePackageResult> associatePackageAsync(AssociatePackageRequest request) {
        return this.associatePackageAsync(request, null);
    }

    @Override
    public Future<AssociatePackageResult> associatePackageAsync(AssociatePackageRequest request, final AsyncHandler<AssociatePackageRequest, AssociatePackageResult> asyncHandler) {
        final AssociatePackageRequest finalRequest = (AssociatePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociatePackageResult>(){

            @Override
            public AssociatePackageResult call() throws Exception {
                AssociatePackageResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeAssociatePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AuthorizeVpcEndpointAccessResult> authorizeVpcEndpointAccessAsync(AuthorizeVpcEndpointAccessRequest request) {
        return this.authorizeVpcEndpointAccessAsync(request, null);
    }

    @Override
    public Future<AuthorizeVpcEndpointAccessResult> authorizeVpcEndpointAccessAsync(AuthorizeVpcEndpointAccessRequest request, final AsyncHandler<AuthorizeVpcEndpointAccessRequest, AuthorizeVpcEndpointAccessResult> asyncHandler) {
        final AuthorizeVpcEndpointAccessRequest finalRequest = (AuthorizeVpcEndpointAccessRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AuthorizeVpcEndpointAccessResult>(){

            @Override
            public AuthorizeVpcEndpointAccessResult call() throws Exception {
                AuthorizeVpcEndpointAccessResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeAuthorizeVpcEndpointAccess(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelServiceSoftwareUpdateResult> cancelServiceSoftwareUpdateAsync(CancelServiceSoftwareUpdateRequest request) {
        return this.cancelServiceSoftwareUpdateAsync(request, null);
    }

    @Override
    public Future<CancelServiceSoftwareUpdateResult> cancelServiceSoftwareUpdateAsync(CancelServiceSoftwareUpdateRequest request, final AsyncHandler<CancelServiceSoftwareUpdateRequest, CancelServiceSoftwareUpdateResult> asyncHandler) {
        final CancelServiceSoftwareUpdateRequest finalRequest = (CancelServiceSoftwareUpdateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelServiceSoftwareUpdateResult>(){

            @Override
            public CancelServiceSoftwareUpdateResult call() throws Exception {
                CancelServiceSoftwareUpdateResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeCancelServiceSoftwareUpdate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request) {
        return this.createDomainAsync(request, null);
    }

    @Override
    public Future<CreateDomainResult> createDomainAsync(CreateDomainRequest request, final AsyncHandler<CreateDomainRequest, CreateDomainResult> asyncHandler) {
        final CreateDomainRequest finalRequest = (CreateDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDomainResult>(){

            @Override
            public CreateDomainResult call() throws Exception {
                CreateDomainResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeCreateDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOutboundConnectionResult> createOutboundConnectionAsync(CreateOutboundConnectionRequest request) {
        return this.createOutboundConnectionAsync(request, null);
    }

    @Override
    public Future<CreateOutboundConnectionResult> createOutboundConnectionAsync(CreateOutboundConnectionRequest request, final AsyncHandler<CreateOutboundConnectionRequest, CreateOutboundConnectionResult> asyncHandler) {
        final CreateOutboundConnectionRequest finalRequest = (CreateOutboundConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOutboundConnectionResult>(){

            @Override
            public CreateOutboundConnectionResult call() throws Exception {
                CreateOutboundConnectionResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeCreateOutboundConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePackageResult> createPackageAsync(CreatePackageRequest request) {
        return this.createPackageAsync(request, null);
    }

    @Override
    public Future<CreatePackageResult> createPackageAsync(CreatePackageRequest request, final AsyncHandler<CreatePackageRequest, CreatePackageResult> asyncHandler) {
        final CreatePackageRequest finalRequest = (CreatePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePackageResult>(){

            @Override
            public CreatePackageResult call() throws Exception {
                CreatePackageResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeCreatePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest request) {
        return this.createVpcEndpointAsync(request, null);
    }

    @Override
    public Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest request, final AsyncHandler<CreateVpcEndpointRequest, CreateVpcEndpointResult> asyncHandler) {
        final CreateVpcEndpointRequest finalRequest = (CreateVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVpcEndpointResult>(){

            @Override
            public CreateVpcEndpointResult call() throws Exception {
                CreateVpcEndpointResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeCreateVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request) {
        return this.deleteDomainAsync(request, null);
    }

    @Override
    public Future<DeleteDomainResult> deleteDomainAsync(DeleteDomainRequest request, final AsyncHandler<DeleteDomainRequest, DeleteDomainResult> asyncHandler) {
        final DeleteDomainRequest finalRequest = (DeleteDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDomainResult>(){

            @Override
            public DeleteDomainResult call() throws Exception {
                DeleteDomainResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDeleteDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInboundConnectionResult> deleteInboundConnectionAsync(DeleteInboundConnectionRequest request) {
        return this.deleteInboundConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteInboundConnectionResult> deleteInboundConnectionAsync(DeleteInboundConnectionRequest request, final AsyncHandler<DeleteInboundConnectionRequest, DeleteInboundConnectionResult> asyncHandler) {
        final DeleteInboundConnectionRequest finalRequest = (DeleteInboundConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInboundConnectionResult>(){

            @Override
            public DeleteInboundConnectionResult call() throws Exception {
                DeleteInboundConnectionResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDeleteInboundConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOutboundConnectionResult> deleteOutboundConnectionAsync(DeleteOutboundConnectionRequest request) {
        return this.deleteOutboundConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteOutboundConnectionResult> deleteOutboundConnectionAsync(DeleteOutboundConnectionRequest request, final AsyncHandler<DeleteOutboundConnectionRequest, DeleteOutboundConnectionResult> asyncHandler) {
        final DeleteOutboundConnectionRequest finalRequest = (DeleteOutboundConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOutboundConnectionResult>(){

            @Override
            public DeleteOutboundConnectionResult call() throws Exception {
                DeleteOutboundConnectionResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDeleteOutboundConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePackageResult> deletePackageAsync(DeletePackageRequest request) {
        return this.deletePackageAsync(request, null);
    }

    @Override
    public Future<DeletePackageResult> deletePackageAsync(DeletePackageRequest request, final AsyncHandler<DeletePackageRequest, DeletePackageResult> asyncHandler) {
        final DeletePackageRequest finalRequest = (DeletePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePackageResult>(){

            @Override
            public DeletePackageResult call() throws Exception {
                DeletePackageResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDeletePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVpcEndpointResult> deleteVpcEndpointAsync(DeleteVpcEndpointRequest request) {
        return this.deleteVpcEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteVpcEndpointResult> deleteVpcEndpointAsync(DeleteVpcEndpointRequest request, final AsyncHandler<DeleteVpcEndpointRequest, DeleteVpcEndpointResult> asyncHandler) {
        final DeleteVpcEndpointRequest finalRequest = (DeleteVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVpcEndpointResult>(){

            @Override
            public DeleteVpcEndpointResult call() throws Exception {
                DeleteVpcEndpointResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDeleteVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainResult> describeDomainAsync(DescribeDomainRequest request) {
        return this.describeDomainAsync(request, null);
    }

    @Override
    public Future<DescribeDomainResult> describeDomainAsync(DescribeDomainRequest request, final AsyncHandler<DescribeDomainRequest, DescribeDomainResult> asyncHandler) {
        final DescribeDomainRequest finalRequest = (DescribeDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainResult>(){

            @Override
            public DescribeDomainResult call() throws Exception {
                DescribeDomainResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainAutoTunesResult> describeDomainAutoTunesAsync(DescribeDomainAutoTunesRequest request) {
        return this.describeDomainAutoTunesAsync(request, null);
    }

    @Override
    public Future<DescribeDomainAutoTunesResult> describeDomainAutoTunesAsync(DescribeDomainAutoTunesRequest request, final AsyncHandler<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResult> asyncHandler) {
        final DescribeDomainAutoTunesRequest finalRequest = (DescribeDomainAutoTunesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainAutoTunesResult>(){

            @Override
            public DescribeDomainAutoTunesResult call() throws Exception {
                DescribeDomainAutoTunesResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomainAutoTunes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainChangeProgressResult> describeDomainChangeProgressAsync(DescribeDomainChangeProgressRequest request) {
        return this.describeDomainChangeProgressAsync(request, null);
    }

    @Override
    public Future<DescribeDomainChangeProgressResult> describeDomainChangeProgressAsync(DescribeDomainChangeProgressRequest request, final AsyncHandler<DescribeDomainChangeProgressRequest, DescribeDomainChangeProgressResult> asyncHandler) {
        final DescribeDomainChangeProgressRequest finalRequest = (DescribeDomainChangeProgressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainChangeProgressResult>(){

            @Override
            public DescribeDomainChangeProgressResult call() throws Exception {
                DescribeDomainChangeProgressResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomainChangeProgress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainConfigResult> describeDomainConfigAsync(DescribeDomainConfigRequest request) {
        return this.describeDomainConfigAsync(request, null);
    }

    @Override
    public Future<DescribeDomainConfigResult> describeDomainConfigAsync(DescribeDomainConfigRequest request, final AsyncHandler<DescribeDomainConfigRequest, DescribeDomainConfigResult> asyncHandler) {
        final DescribeDomainConfigRequest finalRequest = (DescribeDomainConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainConfigResult>(){

            @Override
            public DescribeDomainConfigResult call() throws Exception {
                DescribeDomainConfigResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomainConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainHealthResult> describeDomainHealthAsync(DescribeDomainHealthRequest request) {
        return this.describeDomainHealthAsync(request, null);
    }

    @Override
    public Future<DescribeDomainHealthResult> describeDomainHealthAsync(DescribeDomainHealthRequest request, final AsyncHandler<DescribeDomainHealthRequest, DescribeDomainHealthResult> asyncHandler) {
        final DescribeDomainHealthRequest finalRequest = (DescribeDomainHealthRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainHealthResult>(){

            @Override
            public DescribeDomainHealthResult call() throws Exception {
                DescribeDomainHealthResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomainHealth(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainNodesResult> describeDomainNodesAsync(DescribeDomainNodesRequest request) {
        return this.describeDomainNodesAsync(request, null);
    }

    @Override
    public Future<DescribeDomainNodesResult> describeDomainNodesAsync(DescribeDomainNodesRequest request, final AsyncHandler<DescribeDomainNodesRequest, DescribeDomainNodesResult> asyncHandler) {
        final DescribeDomainNodesRequest finalRequest = (DescribeDomainNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainNodesResult>(){

            @Override
            public DescribeDomainNodesResult call() throws Exception {
                DescribeDomainNodesResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomainNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDomainsResult> describeDomainsAsync(DescribeDomainsRequest request) {
        return this.describeDomainsAsync(request, null);
    }

    @Override
    public Future<DescribeDomainsResult> describeDomainsAsync(DescribeDomainsRequest request, final AsyncHandler<DescribeDomainsRequest, DescribeDomainsResult> asyncHandler) {
        final DescribeDomainsRequest finalRequest = (DescribeDomainsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainsResult>(){

            @Override
            public DescribeDomainsResult call() throws Exception {
                DescribeDomainsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDomains(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDryRunProgressResult> describeDryRunProgressAsync(DescribeDryRunProgressRequest request) {
        return this.describeDryRunProgressAsync(request, null);
    }

    @Override
    public Future<DescribeDryRunProgressResult> describeDryRunProgressAsync(DescribeDryRunProgressRequest request, final AsyncHandler<DescribeDryRunProgressRequest, DescribeDryRunProgressResult> asyncHandler) {
        final DescribeDryRunProgressRequest finalRequest = (DescribeDryRunProgressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDryRunProgressResult>(){

            @Override
            public DescribeDryRunProgressResult call() throws Exception {
                DescribeDryRunProgressResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeDryRunProgress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInboundConnectionsResult> describeInboundConnectionsAsync(DescribeInboundConnectionsRequest request) {
        return this.describeInboundConnectionsAsync(request, null);
    }

    @Override
    public Future<DescribeInboundConnectionsResult> describeInboundConnectionsAsync(DescribeInboundConnectionsRequest request, final AsyncHandler<DescribeInboundConnectionsRequest, DescribeInboundConnectionsResult> asyncHandler) {
        final DescribeInboundConnectionsRequest finalRequest = (DescribeInboundConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInboundConnectionsResult>(){

            @Override
            public DescribeInboundConnectionsResult call() throws Exception {
                DescribeInboundConnectionsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeInboundConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInstanceTypeLimitsResult> describeInstanceTypeLimitsAsync(DescribeInstanceTypeLimitsRequest request) {
        return this.describeInstanceTypeLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeInstanceTypeLimitsResult> describeInstanceTypeLimitsAsync(DescribeInstanceTypeLimitsRequest request, final AsyncHandler<DescribeInstanceTypeLimitsRequest, DescribeInstanceTypeLimitsResult> asyncHandler) {
        final DescribeInstanceTypeLimitsRequest finalRequest = (DescribeInstanceTypeLimitsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInstanceTypeLimitsResult>(){

            @Override
            public DescribeInstanceTypeLimitsResult call() throws Exception {
                DescribeInstanceTypeLimitsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeInstanceTypeLimits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOutboundConnectionsResult> describeOutboundConnectionsAsync(DescribeOutboundConnectionsRequest request) {
        return this.describeOutboundConnectionsAsync(request, null);
    }

    @Override
    public Future<DescribeOutboundConnectionsResult> describeOutboundConnectionsAsync(DescribeOutboundConnectionsRequest request, final AsyncHandler<DescribeOutboundConnectionsRequest, DescribeOutboundConnectionsResult> asyncHandler) {
        final DescribeOutboundConnectionsRequest finalRequest = (DescribeOutboundConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOutboundConnectionsResult>(){

            @Override
            public DescribeOutboundConnectionsResult call() throws Exception {
                DescribeOutboundConnectionsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeOutboundConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePackagesResult> describePackagesAsync(DescribePackagesRequest request) {
        return this.describePackagesAsync(request, null);
    }

    @Override
    public Future<DescribePackagesResult> describePackagesAsync(DescribePackagesRequest request, final AsyncHandler<DescribePackagesRequest, DescribePackagesResult> asyncHandler) {
        final DescribePackagesRequest finalRequest = (DescribePackagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePackagesResult>(){

            @Override
            public DescribePackagesResult call() throws Exception {
                DescribePackagesResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribePackages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstanceOfferingsResult> describeReservedInstanceOfferingsAsync(DescribeReservedInstanceOfferingsRequest request) {
        return this.describeReservedInstanceOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeReservedInstanceOfferingsResult> describeReservedInstanceOfferingsAsync(DescribeReservedInstanceOfferingsRequest request, final AsyncHandler<DescribeReservedInstanceOfferingsRequest, DescribeReservedInstanceOfferingsResult> asyncHandler) {
        final DescribeReservedInstanceOfferingsRequest finalRequest = (DescribeReservedInstanceOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservedInstanceOfferingsResult>(){

            @Override
            public DescribeReservedInstanceOfferingsResult call() throws Exception {
                DescribeReservedInstanceOfferingsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeReservedInstanceOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(DescribeReservedInstancesRequest request) {
        return this.describeReservedInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(DescribeReservedInstancesRequest request, final AsyncHandler<DescribeReservedInstancesRequest, DescribeReservedInstancesResult> asyncHandler) {
        final DescribeReservedInstancesRequest finalRequest = (DescribeReservedInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservedInstancesResult>(){

            @Override
            public DescribeReservedInstancesResult call() throws Exception {
                DescribeReservedInstancesResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeReservedInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(DescribeVpcEndpointsRequest request) {
        return this.describeVpcEndpointsAsync(request, null);
    }

    @Override
    public Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(DescribeVpcEndpointsRequest request, final AsyncHandler<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResult> asyncHandler) {
        final DescribeVpcEndpointsRequest finalRequest = (DescribeVpcEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVpcEndpointsResult>(){

            @Override
            public DescribeVpcEndpointsResult call() throws Exception {
                DescribeVpcEndpointsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDescribeVpcEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DissociatePackageResult> dissociatePackageAsync(DissociatePackageRequest request) {
        return this.dissociatePackageAsync(request, null);
    }

    @Override
    public Future<DissociatePackageResult> dissociatePackageAsync(DissociatePackageRequest request, final AsyncHandler<DissociatePackageRequest, DissociatePackageResult> asyncHandler) {
        final DissociatePackageRequest finalRequest = (DissociatePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DissociatePackageResult>(){

            @Override
            public DissociatePackageResult call() throws Exception {
                DissociatePackageResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeDissociatePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCompatibleVersionsResult> getCompatibleVersionsAsync(GetCompatibleVersionsRequest request) {
        return this.getCompatibleVersionsAsync(request, null);
    }

    @Override
    public Future<GetCompatibleVersionsResult> getCompatibleVersionsAsync(GetCompatibleVersionsRequest request, final AsyncHandler<GetCompatibleVersionsRequest, GetCompatibleVersionsResult> asyncHandler) {
        final GetCompatibleVersionsRequest finalRequest = (GetCompatibleVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCompatibleVersionsResult>(){

            @Override
            public GetCompatibleVersionsResult call() throws Exception {
                GetCompatibleVersionsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeGetCompatibleVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPackageVersionHistoryResult> getPackageVersionHistoryAsync(GetPackageVersionHistoryRequest request) {
        return this.getPackageVersionHistoryAsync(request, null);
    }

    @Override
    public Future<GetPackageVersionHistoryResult> getPackageVersionHistoryAsync(GetPackageVersionHistoryRequest request, final AsyncHandler<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResult> asyncHandler) {
        final GetPackageVersionHistoryRequest finalRequest = (GetPackageVersionHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPackageVersionHistoryResult>(){

            @Override
            public GetPackageVersionHistoryResult call() throws Exception {
                GetPackageVersionHistoryResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeGetPackageVersionHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUpgradeHistoryResult> getUpgradeHistoryAsync(GetUpgradeHistoryRequest request) {
        return this.getUpgradeHistoryAsync(request, null);
    }

    @Override
    public Future<GetUpgradeHistoryResult> getUpgradeHistoryAsync(GetUpgradeHistoryRequest request, final AsyncHandler<GetUpgradeHistoryRequest, GetUpgradeHistoryResult> asyncHandler) {
        final GetUpgradeHistoryRequest finalRequest = (GetUpgradeHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUpgradeHistoryResult>(){

            @Override
            public GetUpgradeHistoryResult call() throws Exception {
                GetUpgradeHistoryResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeGetUpgradeHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUpgradeStatusResult> getUpgradeStatusAsync(GetUpgradeStatusRequest request) {
        return this.getUpgradeStatusAsync(request, null);
    }

    @Override
    public Future<GetUpgradeStatusResult> getUpgradeStatusAsync(GetUpgradeStatusRequest request, final AsyncHandler<GetUpgradeStatusRequest, GetUpgradeStatusResult> asyncHandler) {
        final GetUpgradeStatusRequest finalRequest = (GetUpgradeStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUpgradeStatusResult>(){

            @Override
            public GetUpgradeStatusResult call() throws Exception {
                GetUpgradeStatusResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeGetUpgradeStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDomainNamesResult> listDomainNamesAsync(ListDomainNamesRequest request) {
        return this.listDomainNamesAsync(request, null);
    }

    @Override
    public Future<ListDomainNamesResult> listDomainNamesAsync(ListDomainNamesRequest request, final AsyncHandler<ListDomainNamesRequest, ListDomainNamesResult> asyncHandler) {
        final ListDomainNamesRequest finalRequest = (ListDomainNamesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDomainNamesResult>(){

            @Override
            public ListDomainNamesResult call() throws Exception {
                ListDomainNamesResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListDomainNames(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDomainsForPackageResult> listDomainsForPackageAsync(ListDomainsForPackageRequest request) {
        return this.listDomainsForPackageAsync(request, null);
    }

    @Override
    public Future<ListDomainsForPackageResult> listDomainsForPackageAsync(ListDomainsForPackageRequest request, final AsyncHandler<ListDomainsForPackageRequest, ListDomainsForPackageResult> asyncHandler) {
        final ListDomainsForPackageRequest finalRequest = (ListDomainsForPackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDomainsForPackageResult>(){

            @Override
            public ListDomainsForPackageResult call() throws Exception {
                ListDomainsForPackageResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListDomainsForPackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInstanceTypeDetailsResult> listInstanceTypeDetailsAsync(ListInstanceTypeDetailsRequest request) {
        return this.listInstanceTypeDetailsAsync(request, null);
    }

    @Override
    public Future<ListInstanceTypeDetailsResult> listInstanceTypeDetailsAsync(ListInstanceTypeDetailsRequest request, final AsyncHandler<ListInstanceTypeDetailsRequest, ListInstanceTypeDetailsResult> asyncHandler) {
        final ListInstanceTypeDetailsRequest finalRequest = (ListInstanceTypeDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInstanceTypeDetailsResult>(){

            @Override
            public ListInstanceTypeDetailsResult call() throws Exception {
                ListInstanceTypeDetailsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListInstanceTypeDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPackagesForDomainResult> listPackagesForDomainAsync(ListPackagesForDomainRequest request) {
        return this.listPackagesForDomainAsync(request, null);
    }

    @Override
    public Future<ListPackagesForDomainResult> listPackagesForDomainAsync(ListPackagesForDomainRequest request, final AsyncHandler<ListPackagesForDomainRequest, ListPackagesForDomainResult> asyncHandler) {
        final ListPackagesForDomainRequest finalRequest = (ListPackagesForDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPackagesForDomainResult>(){

            @Override
            public ListPackagesForDomainResult call() throws Exception {
                ListPackagesForDomainResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListPackagesForDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListScheduledActionsResult> listScheduledActionsAsync(ListScheduledActionsRequest request) {
        return this.listScheduledActionsAsync(request, null);
    }

    @Override
    public Future<ListScheduledActionsResult> listScheduledActionsAsync(ListScheduledActionsRequest request, final AsyncHandler<ListScheduledActionsRequest, ListScheduledActionsResult> asyncHandler) {
        final ListScheduledActionsRequest finalRequest = (ListScheduledActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListScheduledActionsResult>(){

            @Override
            public ListScheduledActionsResult call() throws Exception {
                ListScheduledActionsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListScheduledActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVersionsResult> listVersionsAsync(ListVersionsRequest request) {
        return this.listVersionsAsync(request, null);
    }

    @Override
    public Future<ListVersionsResult> listVersionsAsync(ListVersionsRequest request, final AsyncHandler<ListVersionsRequest, ListVersionsResult> asyncHandler) {
        final ListVersionsRequest finalRequest = (ListVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVersionsResult>(){

            @Override
            public ListVersionsResult call() throws Exception {
                ListVersionsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVpcEndpointAccessResult> listVpcEndpointAccessAsync(ListVpcEndpointAccessRequest request) {
        return this.listVpcEndpointAccessAsync(request, null);
    }

    @Override
    public Future<ListVpcEndpointAccessResult> listVpcEndpointAccessAsync(ListVpcEndpointAccessRequest request, final AsyncHandler<ListVpcEndpointAccessRequest, ListVpcEndpointAccessResult> asyncHandler) {
        final ListVpcEndpointAccessRequest finalRequest = (ListVpcEndpointAccessRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVpcEndpointAccessResult>(){

            @Override
            public ListVpcEndpointAccessResult call() throws Exception {
                ListVpcEndpointAccessResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListVpcEndpointAccess(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVpcEndpointsResult> listVpcEndpointsAsync(ListVpcEndpointsRequest request) {
        return this.listVpcEndpointsAsync(request, null);
    }

    @Override
    public Future<ListVpcEndpointsResult> listVpcEndpointsAsync(ListVpcEndpointsRequest request, final AsyncHandler<ListVpcEndpointsRequest, ListVpcEndpointsResult> asyncHandler) {
        final ListVpcEndpointsRequest finalRequest = (ListVpcEndpointsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVpcEndpointsResult>(){

            @Override
            public ListVpcEndpointsResult call() throws Exception {
                ListVpcEndpointsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListVpcEndpoints(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVpcEndpointsForDomainResult> listVpcEndpointsForDomainAsync(ListVpcEndpointsForDomainRequest request) {
        return this.listVpcEndpointsForDomainAsync(request, null);
    }

    @Override
    public Future<ListVpcEndpointsForDomainResult> listVpcEndpointsForDomainAsync(ListVpcEndpointsForDomainRequest request, final AsyncHandler<ListVpcEndpointsForDomainRequest, ListVpcEndpointsForDomainResult> asyncHandler) {
        final ListVpcEndpointsForDomainRequest finalRequest = (ListVpcEndpointsForDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVpcEndpointsForDomainResult>(){

            @Override
            public ListVpcEndpointsForDomainResult call() throws Exception {
                ListVpcEndpointsForDomainResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeListVpcEndpointsForDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseReservedInstanceOfferingResult> purchaseReservedInstanceOfferingAsync(PurchaseReservedInstanceOfferingRequest request) {
        return this.purchaseReservedInstanceOfferingAsync(request, null);
    }

    @Override
    public Future<PurchaseReservedInstanceOfferingResult> purchaseReservedInstanceOfferingAsync(PurchaseReservedInstanceOfferingRequest request, final AsyncHandler<PurchaseReservedInstanceOfferingRequest, PurchaseReservedInstanceOfferingResult> asyncHandler) {
        final PurchaseReservedInstanceOfferingRequest finalRequest = (PurchaseReservedInstanceOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PurchaseReservedInstanceOfferingResult>(){

            @Override
            public PurchaseReservedInstanceOfferingResult call() throws Exception {
                PurchaseReservedInstanceOfferingResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executePurchaseReservedInstanceOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectInboundConnectionResult> rejectInboundConnectionAsync(RejectInboundConnectionRequest request) {
        return this.rejectInboundConnectionAsync(request, null);
    }

    @Override
    public Future<RejectInboundConnectionResult> rejectInboundConnectionAsync(RejectInboundConnectionRequest request, final AsyncHandler<RejectInboundConnectionRequest, RejectInboundConnectionResult> asyncHandler) {
        final RejectInboundConnectionRequest finalRequest = (RejectInboundConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectInboundConnectionResult>(){

            @Override
            public RejectInboundConnectionResult call() throws Exception {
                RejectInboundConnectionResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeRejectInboundConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request) {
        return this.removeTagsAsync(request, null);
    }

    @Override
    public Future<RemoveTagsResult> removeTagsAsync(RemoveTagsRequest request, final AsyncHandler<RemoveTagsRequest, RemoveTagsResult> asyncHandler) {
        final RemoveTagsRequest finalRequest = (RemoveTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsResult>(){

            @Override
            public RemoveTagsResult call() throws Exception {
                RemoveTagsResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeRemoveTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokeVpcEndpointAccessResult> revokeVpcEndpointAccessAsync(RevokeVpcEndpointAccessRequest request) {
        return this.revokeVpcEndpointAccessAsync(request, null);
    }

    @Override
    public Future<RevokeVpcEndpointAccessResult> revokeVpcEndpointAccessAsync(RevokeVpcEndpointAccessRequest request, final AsyncHandler<RevokeVpcEndpointAccessRequest, RevokeVpcEndpointAccessResult> asyncHandler) {
        final RevokeVpcEndpointAccessRequest finalRequest = (RevokeVpcEndpointAccessRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokeVpcEndpointAccessResult>(){

            @Override
            public RevokeVpcEndpointAccessResult call() throws Exception {
                RevokeVpcEndpointAccessResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeRevokeVpcEndpointAccess(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartServiceSoftwareUpdateResult> startServiceSoftwareUpdateAsync(StartServiceSoftwareUpdateRequest request) {
        return this.startServiceSoftwareUpdateAsync(request, null);
    }

    @Override
    public Future<StartServiceSoftwareUpdateResult> startServiceSoftwareUpdateAsync(StartServiceSoftwareUpdateRequest request, final AsyncHandler<StartServiceSoftwareUpdateRequest, StartServiceSoftwareUpdateResult> asyncHandler) {
        final StartServiceSoftwareUpdateRequest finalRequest = (StartServiceSoftwareUpdateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartServiceSoftwareUpdateResult>(){

            @Override
            public StartServiceSoftwareUpdateResult call() throws Exception {
                StartServiceSoftwareUpdateResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeStartServiceSoftwareUpdate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDomainConfigResult> updateDomainConfigAsync(UpdateDomainConfigRequest request) {
        return this.updateDomainConfigAsync(request, null);
    }

    @Override
    public Future<UpdateDomainConfigResult> updateDomainConfigAsync(UpdateDomainConfigRequest request, final AsyncHandler<UpdateDomainConfigRequest, UpdateDomainConfigResult> asyncHandler) {
        final UpdateDomainConfigRequest finalRequest = (UpdateDomainConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDomainConfigResult>(){

            @Override
            public UpdateDomainConfigResult call() throws Exception {
                UpdateDomainConfigResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeUpdateDomainConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePackageResult> updatePackageAsync(UpdatePackageRequest request) {
        return this.updatePackageAsync(request, null);
    }

    @Override
    public Future<UpdatePackageResult> updatePackageAsync(UpdatePackageRequest request, final AsyncHandler<UpdatePackageRequest, UpdatePackageResult> asyncHandler) {
        final UpdatePackageRequest finalRequest = (UpdatePackageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePackageResult>(){

            @Override
            public UpdatePackageResult call() throws Exception {
                UpdatePackageResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeUpdatePackage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateScheduledActionResult> updateScheduledActionAsync(UpdateScheduledActionRequest request) {
        return this.updateScheduledActionAsync(request, null);
    }

    @Override
    public Future<UpdateScheduledActionResult> updateScheduledActionAsync(UpdateScheduledActionRequest request, final AsyncHandler<UpdateScheduledActionRequest, UpdateScheduledActionResult> asyncHandler) {
        final UpdateScheduledActionRequest finalRequest = (UpdateScheduledActionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateScheduledActionResult>(){

            @Override
            public UpdateScheduledActionResult call() throws Exception {
                UpdateScheduledActionResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeUpdateScheduledAction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVpcEndpointResult> updateVpcEndpointAsync(UpdateVpcEndpointRequest request) {
        return this.updateVpcEndpointAsync(request, null);
    }

    @Override
    public Future<UpdateVpcEndpointResult> updateVpcEndpointAsync(UpdateVpcEndpointRequest request, final AsyncHandler<UpdateVpcEndpointRequest, UpdateVpcEndpointResult> asyncHandler) {
        final UpdateVpcEndpointRequest finalRequest = (UpdateVpcEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVpcEndpointResult>(){

            @Override
            public UpdateVpcEndpointResult call() throws Exception {
                UpdateVpcEndpointResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeUpdateVpcEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpgradeDomainResult> upgradeDomainAsync(UpgradeDomainRequest request) {
        return this.upgradeDomainAsync(request, null);
    }

    @Override
    public Future<UpgradeDomainResult> upgradeDomainAsync(UpgradeDomainRequest request, final AsyncHandler<UpgradeDomainRequest, UpgradeDomainResult> asyncHandler) {
        final UpgradeDomainRequest finalRequest = (UpgradeDomainRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpgradeDomainResult>(){

            @Override
            public UpgradeDomainResult call() throws Exception {
                UpgradeDomainResult result = null;
                try {
                    result = AmazonOpenSearchAsyncClient.this.executeUpgradeDomain(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

