/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.ReservedInstance;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ReservedInstanceMarshaller {
    private static final MarshallingInfo<String> RESERVATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservationName").build();
    private static final MarshallingInfo<String> RESERVEDINSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedInstanceId").build();
    private static final MarshallingInfo<Long> BILLINGSUBSCRIPTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BillingSubscriptionId").build();
    private static final MarshallingInfo<String> RESERVEDINSTANCEOFFERINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedInstanceOfferingId").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").build();
    private static final MarshallingInfo<Double> FIXEDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedPrice").build();
    private static final MarshallingInfo<Double> USAGEPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsagePrice").build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrencyCode").build();
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> PAYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaymentOption").build();
    private static final MarshallingInfo<List> RECURRINGCHARGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurringCharges").build();
    private static final ReservedInstanceMarshaller instance = new ReservedInstanceMarshaller();

    public static ReservedInstanceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReservedInstance reservedInstance, ProtocolMarshaller protocolMarshaller) {
        if (reservedInstance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)reservedInstance.getReservationName(), RESERVATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getReservedInstanceId(), RESERVEDINSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getBillingSubscriptionId(), BILLINGSUBSCRIPTIONID_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getReservedInstanceOfferingId(), RESERVEDINSTANCEOFFERINGID_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getDuration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getFixedPrice(), FIXEDPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getUsagePrice(), USAGEPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getCurrencyCode(), CURRENCYCODE_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getInstanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)reservedInstance.getPaymentOption(), PAYMENTOPTION_BINDING);
            protocolMarshaller.marshall(reservedInstance.getRecurringCharges(), RECURRINGCHARGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

