/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkmanager.model.AWSLocation;

@SdkInternalApi
public class AWSLocationMarshaller {
    private static final MarshallingInfo<String> ZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Zone").build();
    private static final MarshallingInfo<String> SUBNETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetArn").build();
    private static final AWSLocationMarshaller instance = new AWSLocationMarshaller();

    public static AWSLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AWSLocation aWSLocation, ProtocolMarshaller protocolMarshaller) {
        if (aWSLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)aWSLocation.getZone(), ZONE_BINDING);
            protocolMarshaller.marshall((Object)aWSLocation.getSubnetArn(), SUBNETARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

