/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.IPSetMetadata;
import com.amazonaws.services.networkfirewall.model.transform.CIDRSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CIDRSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer availableCIDRCount;
    private Integer utilizedCIDRCount;
    private Map<String, IPSetMetadata> iPSetReferences;

    public void setAvailableCIDRCount(Integer availableCIDRCount) {
        this.availableCIDRCount = availableCIDRCount;
    }

    public Integer getAvailableCIDRCount() {
        return this.availableCIDRCount;
    }

    public CIDRSummary withAvailableCIDRCount(Integer availableCIDRCount) {
        this.setAvailableCIDRCount(availableCIDRCount);
        return this;
    }

    public void setUtilizedCIDRCount(Integer utilizedCIDRCount) {
        this.utilizedCIDRCount = utilizedCIDRCount;
    }

    public Integer getUtilizedCIDRCount() {
        return this.utilizedCIDRCount;
    }

    public CIDRSummary withUtilizedCIDRCount(Integer utilizedCIDRCount) {
        this.setUtilizedCIDRCount(utilizedCIDRCount);
        return this;
    }

    public Map<String, IPSetMetadata> getIPSetReferences() {
        return this.iPSetReferences;
    }

    public void setIPSetReferences(Map<String, IPSetMetadata> iPSetReferences) {
        this.iPSetReferences = iPSetReferences;
    }

    public CIDRSummary withIPSetReferences(Map<String, IPSetMetadata> iPSetReferences) {
        this.setIPSetReferences(iPSetReferences);
        return this;
    }

    public CIDRSummary addIPSetReferencesEntry(String key, IPSetMetadata value) {
        if (null == this.iPSetReferences) {
            this.iPSetReferences = new HashMap<String, IPSetMetadata>();
        }
        if (this.iPSetReferences.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.iPSetReferences.put(key, value);
        return this;
    }

    public CIDRSummary clearIPSetReferencesEntries() {
        this.iPSetReferences = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailableCIDRCount() != null) {
            sb.append("AvailableCIDRCount: ").append(this.getAvailableCIDRCount()).append(",");
        }
        if (this.getUtilizedCIDRCount() != null) {
            sb.append("UtilizedCIDRCount: ").append(this.getUtilizedCIDRCount()).append(",");
        }
        if (this.getIPSetReferences() != null) {
            sb.append("IPSetReferences: ").append(this.getIPSetReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIDRSummary)) {
            return false;
        }
        CIDRSummary other = (CIDRSummary)obj;
        if (other.getAvailableCIDRCount() == null ^ this.getAvailableCIDRCount() == null) {
            return false;
        }
        if (other.getAvailableCIDRCount() != null && !other.getAvailableCIDRCount().equals(this.getAvailableCIDRCount())) {
            return false;
        }
        if (other.getUtilizedCIDRCount() == null ^ this.getUtilizedCIDRCount() == null) {
            return false;
        }
        if (other.getUtilizedCIDRCount() != null && !other.getUtilizedCIDRCount().equals(this.getUtilizedCIDRCount())) {
            return false;
        }
        if (other.getIPSetReferences() == null ^ this.getIPSetReferences() == null) {
            return false;
        }
        return other.getIPSetReferences() == null || other.getIPSetReferences().equals(this.getIPSetReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailableCIDRCount() == null ? 0 : this.getAvailableCIDRCount().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizedCIDRCount() == null ? 0 : this.getUtilizedCIDRCount().hashCode());
        hashCode = 31 * hashCode + (this.getIPSetReferences() == null ? 0 : this.getIPSetReferences().hashCode());
        return hashCode;
    }

    public CIDRSummary clone() {
        try {
            return (CIDRSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CIDRSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

