/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkfirewall.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.networkfirewall.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RuleGroup JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RuleGroupJsonUnmarshaller implements Unmarshaller<RuleGroup, JsonUnmarshallerContext> {

    public RuleGroup unmarshall(JsonUnmarshallerContext context) throws Exception {
        RuleGroup ruleGroup = new RuleGroup();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RuleVariables", targetDepth)) {
                    context.nextToken();
                    ruleGroup.setRuleVariables(RuleVariablesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ReferenceSets", targetDepth)) {
                    context.nextToken();
                    ruleGroup.setReferenceSets(ReferenceSetsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RulesSource", targetDepth)) {
                    context.nextToken();
                    ruleGroup.setRulesSource(RulesSourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StatefulRuleOptions", targetDepth)) {
                    context.nextToken();
                    ruleGroup.setStatefulRuleOptions(StatefulRuleOptionsJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return ruleGroup;
    }

    private static RuleGroupJsonUnmarshaller instance;

    public static RuleGroupJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new RuleGroupJsonUnmarshaller();
        return instance;
    }
}
