/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.neptunedata.model.IllegalArgumentException;
import com.amazonaws.services.neptunedata.model.SparqlData;
import com.amazonaws.services.neptunedata.model.transform.SparqlRecordMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SparqlRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private Long commitTimestampInMillis;
    private Map<String, String> eventId;
    private SparqlData data;
    private String op;
    private Boolean isLastOp;

    public void setCommitTimestampInMillis(Long commitTimestampInMillis) {
        this.commitTimestampInMillis = commitTimestampInMillis;
    }

    public Long getCommitTimestampInMillis() {
        return this.commitTimestampInMillis;
    }

    public SparqlRecord withCommitTimestampInMillis(Long commitTimestampInMillis) {
        this.setCommitTimestampInMillis(commitTimestampInMillis);
        return this;
    }

    public Map<String, String> getEventId() {
        return this.eventId;
    }

    public void setEventId(Map<String, String> eventId) {
        this.eventId = eventId;
    }

    public SparqlRecord withEventId(Map<String, String> eventId) {
        this.setEventId(eventId);
        return this;
    }

    public SparqlRecord addEventIdEntry(String key, String value) {
        if (null == this.eventId) {
            this.eventId = new HashMap<String, String>();
        }
        if (this.eventId.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.eventId.put(key, value);
        return this;
    }

    public SparqlRecord clearEventIdEntries() {
        this.eventId = null;
        return this;
    }

    public void setData(SparqlData data) {
        this.data = data;
    }

    public SparqlData getData() {
        return this.data;
    }

    public SparqlRecord withData(SparqlData data) {
        this.setData(data);
        return this;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getOp() {
        return this.op;
    }

    public SparqlRecord withOp(String op) {
        this.setOp(op);
        return this;
    }

    public void setIsLastOp(Boolean isLastOp) {
        this.isLastOp = isLastOp;
    }

    public Boolean getIsLastOp() {
        return this.isLastOp;
    }

    public SparqlRecord withIsLastOp(Boolean isLastOp) {
        this.setIsLastOp(isLastOp);
        return this;
    }

    public Boolean isLastOp() {
        return this.isLastOp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommitTimestampInMillis() != null) {
            sb.append("CommitTimestampInMillis: ").append(this.getCommitTimestampInMillis()).append(",");
        }
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getOp() != null) {
            sb.append("Op: ").append(this.getOp()).append(",");
        }
        if (this.getIsLastOp() != null) {
            sb.append("IsLastOp: ").append(this.getIsLastOp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparqlRecord)) {
            return false;
        }
        SparqlRecord other = (SparqlRecord)obj;
        if (other.getCommitTimestampInMillis() == null ^ this.getCommitTimestampInMillis() == null) {
            return false;
        }
        if (other.getCommitTimestampInMillis() != null && !other.getCommitTimestampInMillis().equals(this.getCommitTimestampInMillis())) {
            return false;
        }
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getOp() == null ^ this.getOp() == null) {
            return false;
        }
        if (other.getOp() != null && !other.getOp().equals(this.getOp())) {
            return false;
        }
        if (other.getIsLastOp() == null ^ this.getIsLastOp() == null) {
            return false;
        }
        return other.getIsLastOp() == null || other.getIsLastOp().equals(this.getIsLastOp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommitTimestampInMillis() == null ? 0 : this.getCommitTimestampInMillis().hashCode());
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getOp() == null ? 0 : this.getOp().hashCode());
        hashCode = 31 * hashCode + (this.getIsLastOp() == null ? 0 : this.getIsLastOp().hashCode());
        return hashCode;
    }

    public SparqlRecord clone() {
        try {
            return (SparqlRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SparqlRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

