/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mediatailor.model.ChannelState;
import com.amazonaws.services.mediatailor.model.ResponseOutputItem;
import com.amazonaws.services.mediatailor.model.SlateSource;
import com.amazonaws.services.mediatailor.model.TimeShiftConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateChannelResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String arn;
    private List<String> audiences;
    private String channelName;
    private String channelState;
    private Date creationTime;
    private SlateSource fillerSlate;
    private Date lastModifiedTime;
    private List<ResponseOutputItem> outputs;
    private String playbackMode;
    private Map<String, String> tags;
    private String tier;
    private TimeShiftConfiguration timeShiftConfiguration;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public UpdateChannelResult withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(Collection<String> audiences) {
        if (audiences == null) {
            this.audiences = null;
            return;
        }
        this.audiences = new ArrayList<String>(audiences);
    }

    public UpdateChannelResult withAudiences(String ... audiences) {
        if (this.audiences == null) {
            this.setAudiences(new ArrayList<String>(audiences.length));
        }
        for (String ele : audiences) {
            this.audiences.add(ele);
        }
        return this;
    }

    public UpdateChannelResult withAudiences(Collection<String> audiences) {
        this.setAudiences(audiences);
        return this;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public UpdateChannelResult withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public void setChannelState(String channelState) {
        this.channelState = channelState;
    }

    public String getChannelState() {
        return this.channelState;
    }

    public UpdateChannelResult withChannelState(String channelState) {
        this.setChannelState(channelState);
        return this;
    }

    public UpdateChannelResult withChannelState(ChannelState channelState) {
        this.channelState = channelState.toString();
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public UpdateChannelResult withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setFillerSlate(SlateSource fillerSlate) {
        this.fillerSlate = fillerSlate;
    }

    public SlateSource getFillerSlate() {
        return this.fillerSlate;
    }

    public UpdateChannelResult withFillerSlate(SlateSource fillerSlate) {
        this.setFillerSlate(fillerSlate);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public UpdateChannelResult withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<ResponseOutputItem> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<ResponseOutputItem> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<ResponseOutputItem>(outputs);
    }

    public UpdateChannelResult withOutputs(ResponseOutputItem ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<ResponseOutputItem>(outputs.length));
        }
        for (ResponseOutputItem ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public UpdateChannelResult withOutputs(Collection<ResponseOutputItem> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setPlaybackMode(String playbackMode) {
        this.playbackMode = playbackMode;
    }

    public String getPlaybackMode() {
        return this.playbackMode;
    }

    public UpdateChannelResult withPlaybackMode(String playbackMode) {
        this.setPlaybackMode(playbackMode);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public UpdateChannelResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public UpdateChannelResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public UpdateChannelResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public UpdateChannelResult withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public void setTimeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
        this.timeShiftConfiguration = timeShiftConfiguration;
    }

    public TimeShiftConfiguration getTimeShiftConfiguration() {
        return this.timeShiftConfiguration;
    }

    public UpdateChannelResult withTimeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
        this.setTimeShiftConfiguration(timeShiftConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getAudiences() != null) {
            sb.append("Audiences: ").append(this.getAudiences()).append(",");
        }
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getChannelState() != null) {
            sb.append("ChannelState: ").append(this.getChannelState()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getFillerSlate() != null) {
            sb.append("FillerSlate: ").append(this.getFillerSlate()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getPlaybackMode() != null) {
            sb.append("PlaybackMode: ").append(this.getPlaybackMode()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getTimeShiftConfiguration() != null) {
            sb.append("TimeShiftConfiguration: ").append(this.getTimeShiftConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelResult)) {
            return false;
        }
        UpdateChannelResult other = (UpdateChannelResult)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getAudiences() == null ^ this.getAudiences() == null) {
            return false;
        }
        if (other.getAudiences() != null && !other.getAudiences().equals(this.getAudiences())) {
            return false;
        }
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getChannelState() == null ^ this.getChannelState() == null) {
            return false;
        }
        if (other.getChannelState() != null && !other.getChannelState().equals(this.getChannelState())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getFillerSlate() == null ^ this.getFillerSlate() == null) {
            return false;
        }
        if (other.getFillerSlate() != null && !other.getFillerSlate().equals(this.getFillerSlate())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getPlaybackMode() == null ^ this.getPlaybackMode() == null) {
            return false;
        }
        if (other.getPlaybackMode() != null && !other.getPlaybackMode().equals(this.getPlaybackMode())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getTimeShiftConfiguration() == null ^ this.getTimeShiftConfiguration() == null) {
            return false;
        }
        return other.getTimeShiftConfiguration() == null || other.getTimeShiftConfiguration().equals(this.getTimeShiftConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getAudiences() == null ? 0 : this.getAudiences().hashCode());
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getChannelState() == null ? 0 : this.getChannelState().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFillerSlate() == null ? 0 : this.getFillerSlate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getPlaybackMode() == null ? 0 : this.getPlaybackMode().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getTimeShiftConfiguration() == null ? 0 : this.getTimeShiftConfiguration().hashCode());
        return hashCode;
    }

    public UpdateChannelResult clone() {
        try {
            return (UpdateChannelResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

