/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediatailor.model.PlaybackMode;
import com.amazonaws.services.mediatailor.model.RequestOutputItem;
import com.amazonaws.services.mediatailor.model.SlateSource;
import com.amazonaws.services.mediatailor.model.Tier;
import com.amazonaws.services.mediatailor.model.TimeShiftConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> audiences;
    private String channelName;
    private SlateSource fillerSlate;
    private List<RequestOutputItem> outputs;
    private String playbackMode;
    private Map<String, String> tags;
    private String tier;
    private TimeShiftConfiguration timeShiftConfiguration;

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(Collection<String> audiences) {
        if (audiences == null) {
            this.audiences = null;
            return;
        }
        this.audiences = new ArrayList<String>(audiences);
    }

    public CreateChannelRequest withAudiences(String ... audiences) {
        if (this.audiences == null) {
            this.setAudiences(new ArrayList<String>(audiences.length));
        }
        for (String ele : audiences) {
            this.audiences.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withAudiences(Collection<String> audiences) {
        this.setAudiences(audiences);
        return this;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public CreateChannelRequest withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public void setFillerSlate(SlateSource fillerSlate) {
        this.fillerSlate = fillerSlate;
    }

    public SlateSource getFillerSlate() {
        return this.fillerSlate;
    }

    public CreateChannelRequest withFillerSlate(SlateSource fillerSlate) {
        this.setFillerSlate(fillerSlate);
        return this;
    }

    public List<RequestOutputItem> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<RequestOutputItem> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<RequestOutputItem>(outputs);
    }

    public CreateChannelRequest withOutputs(RequestOutputItem ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<RequestOutputItem>(outputs.length));
        }
        for (RequestOutputItem ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withOutputs(Collection<RequestOutputItem> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setPlaybackMode(String playbackMode) {
        this.playbackMode = playbackMode;
    }

    public String getPlaybackMode() {
        return this.playbackMode;
    }

    public CreateChannelRequest withPlaybackMode(String playbackMode) {
        this.setPlaybackMode(playbackMode);
        return this;
    }

    public CreateChannelRequest withPlaybackMode(PlaybackMode playbackMode) {
        this.playbackMode = playbackMode.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateChannelRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateChannelRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateChannelRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public CreateChannelRequest withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public CreateChannelRequest withTier(Tier tier) {
        this.tier = tier.toString();
        return this;
    }

    public void setTimeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
        this.timeShiftConfiguration = timeShiftConfiguration;
    }

    public TimeShiftConfiguration getTimeShiftConfiguration() {
        return this.timeShiftConfiguration;
    }

    public CreateChannelRequest withTimeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
        this.setTimeShiftConfiguration(timeShiftConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudiences() != null) {
            sb.append("Audiences: ").append(this.getAudiences()).append(",");
        }
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getFillerSlate() != null) {
            sb.append("FillerSlate: ").append(this.getFillerSlate()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getPlaybackMode() != null) {
            sb.append("PlaybackMode: ").append(this.getPlaybackMode()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getTimeShiftConfiguration() != null) {
            sb.append("TimeShiftConfiguration: ").append(this.getTimeShiftConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)obj;
        if (other.getAudiences() == null ^ this.getAudiences() == null) {
            return false;
        }
        if (other.getAudiences() != null && !other.getAudiences().equals(this.getAudiences())) {
            return false;
        }
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getFillerSlate() == null ^ this.getFillerSlate() == null) {
            return false;
        }
        if (other.getFillerSlate() != null && !other.getFillerSlate().equals(this.getFillerSlate())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getPlaybackMode() == null ^ this.getPlaybackMode() == null) {
            return false;
        }
        if (other.getPlaybackMode() != null && !other.getPlaybackMode().equals(this.getPlaybackMode())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getTimeShiftConfiguration() == null ^ this.getTimeShiftConfiguration() == null) {
            return false;
        }
        return other.getTimeShiftConfiguration() == null || other.getTimeShiftConfiguration().equals(this.getTimeShiftConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudiences() == null ? 0 : this.getAudiences().hashCode());
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getFillerSlate() == null ? 0 : this.getFillerSlate().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getPlaybackMode() == null ? 0 : this.getPlaybackMode().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getTimeShiftConfiguration() == null ? 0 : this.getTimeShiftConfiguration().hashCode());
        return hashCode;
    }

    public CreateChannelRequest clone() {
        return (CreateChannelRequest)super.clone();
    }
}

