/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastoredata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediastoredata.AWSMediaStoreDataAsync;
import com.amazonaws.services.mediastoredata.AWSMediaStoreDataAsyncClientBuilder;
import com.amazonaws.services.mediastoredata.AWSMediaStoreDataClient;
import com.amazonaws.services.mediastoredata.model.DeleteObjectRequest;
import com.amazonaws.services.mediastoredata.model.DeleteObjectResult;
import com.amazonaws.services.mediastoredata.model.DescribeObjectRequest;
import com.amazonaws.services.mediastoredata.model.DescribeObjectResult;
import com.amazonaws.services.mediastoredata.model.GetObjectRequest;
import com.amazonaws.services.mediastoredata.model.GetObjectResult;
import com.amazonaws.services.mediastoredata.model.ListItemsRequest;
import com.amazonaws.services.mediastoredata.model.ListItemsResult;
import com.amazonaws.services.mediastoredata.model.PutObjectRequest;
import com.amazonaws.services.mediastoredata.model.PutObjectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaStoreDataAsyncClient
extends AWSMediaStoreDataClient
implements AWSMediaStoreDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaStoreDataAsyncClientBuilder asyncBuilder() {
        return AWSMediaStoreDataAsyncClientBuilder.standard();
    }

    AWSMediaStoreDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaStoreDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request) {
        return this.deleteObjectAsync(request, null);
    }

    @Override
    public Future<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request, final AsyncHandler<DeleteObjectRequest, DeleteObjectResult> asyncHandler) {
        final DeleteObjectRequest finalRequest = (DeleteObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteObjectResult>(){

            @Override
            public DeleteObjectResult call() throws Exception {
                DeleteObjectResult result = null;
                try {
                    result = AWSMediaStoreDataAsyncClient.this.executeDeleteObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeObjectResult> describeObjectAsync(DescribeObjectRequest request) {
        return this.describeObjectAsync(request, null);
    }

    @Override
    public Future<DescribeObjectResult> describeObjectAsync(DescribeObjectRequest request, final AsyncHandler<DescribeObjectRequest, DescribeObjectResult> asyncHandler) {
        final DescribeObjectRequest finalRequest = (DescribeObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeObjectResult>(){

            @Override
            public DescribeObjectResult call() throws Exception {
                DescribeObjectResult result = null;
                try {
                    result = AWSMediaStoreDataAsyncClient.this.executeDescribeObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetObjectResult> getObjectAsync(GetObjectRequest request) {
        return this.getObjectAsync(request, null);
    }

    @Override
    public Future<GetObjectResult> getObjectAsync(GetObjectRequest request, final AsyncHandler<GetObjectRequest, GetObjectResult> asyncHandler) {
        final GetObjectRequest finalRequest = (GetObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetObjectResult>(){

            @Override
            public GetObjectResult call() throws Exception {
                GetObjectResult result = null;
                try {
                    result = AWSMediaStoreDataAsyncClient.this.executeGetObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListItemsResult> listItemsAsync(ListItemsRequest request) {
        return this.listItemsAsync(request, null);
    }

    @Override
    public Future<ListItemsResult> listItemsAsync(ListItemsRequest request, final AsyncHandler<ListItemsRequest, ListItemsResult> asyncHandler) {
        final ListItemsRequest finalRequest = (ListItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListItemsResult>(){

            @Override
            public ListItemsResult call() throws Exception {
                ListItemsResult result = null;
                try {
                    result = AWSMediaStoreDataAsyncClient.this.executeListItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutObjectResult> putObjectAsync(PutObjectRequest request) {
        return this.putObjectAsync(request, null);
    }

    @Override
    public Future<PutObjectResult> putObjectAsync(PutObjectRequest request, final AsyncHandler<PutObjectRequest, PutObjectResult> asyncHandler) {
        final PutObjectRequest finalRequest = (PutObjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutObjectResult>(){

            @Override
            public PutObjectResult call() throws Exception {
                PutObjectResult result = null;
                try {
                    result = AWSMediaStoreDataAsyncClient.this.executePutObject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

