/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mediapackage.model.OriginEndpoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListOriginEndpointsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<OriginEndpoint> originEndpoints;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListOriginEndpointsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<OriginEndpoint> getOriginEndpoints() {
        return this.originEndpoints;
    }

    public void setOriginEndpoints(Collection<OriginEndpoint> originEndpoints) {
        if (originEndpoints == null) {
            this.originEndpoints = null;
            return;
        }
        this.originEndpoints = new ArrayList<OriginEndpoint>(originEndpoints);
    }

    public ListOriginEndpointsResult withOriginEndpoints(OriginEndpoint ... originEndpoints) {
        if (this.originEndpoints == null) {
            this.setOriginEndpoints(new ArrayList<OriginEndpoint>(originEndpoints.length));
        }
        for (OriginEndpoint ele : originEndpoints) {
            this.originEndpoints.add(ele);
        }
        return this;
    }

    public ListOriginEndpointsResult withOriginEndpoints(Collection<OriginEndpoint> originEndpoints) {
        this.setOriginEndpoints(originEndpoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getOriginEndpoints() != null) {
            sb.append("OriginEndpoints: ").append(this.getOriginEndpoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginEndpointsResult)) {
            return false;
        }
        ListOriginEndpointsResult other = (ListOriginEndpointsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getOriginEndpoints() == null ^ this.getOriginEndpoints() == null) {
            return false;
        }
        return other.getOriginEndpoints() == null || other.getOriginEndpoints().equals(this.getOriginEndpoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getOriginEndpoints() == null ? 0 : this.getOriginEndpoints().hashCode());
        return hashCode;
    }

    public ListOriginEndpointsResult clone() {
        try {
            return (ListOriginEndpointsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

