/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.Output;
import java.util.List;

@SdkInternalApi
public class OutputMarshaller {
    private static final MarshallingInfo<List> AUDIODESCRIPTIONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDescriptionNames").build();
    private static final MarshallingInfo<List> CAPTIONDESCRIPTIONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionDescriptionNames").build();
    private static final MarshallingInfo<String> OUTPUTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputName").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputSettings").build();
    private static final MarshallingInfo<String> VIDEODESCRIPTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoDescriptionName").build();
    private static final OutputMarshaller instance = new OutputMarshaller();

    public static OutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(Output output, ProtocolMarshaller protocolMarshaller) {
        if (output == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(output.getAudioDescriptionNames(), AUDIODESCRIPTIONNAMES_BINDING);
            protocolMarshaller.marshall(output.getCaptionDescriptionNames(), CAPTIONDESCRIPTIONNAMES_BINDING);
            protocolMarshaller.marshall((Object)output.getOutputName(), OUTPUTNAME_BINDING);
            protocolMarshaller.marshall((Object)output.getOutputSettings(), OUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)output.getVideoDescriptionName(), VIDEODESCRIPTIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

