/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.AudioChannelMapping;
import java.util.List;

@SdkInternalApi
public class AudioChannelMappingMarshaller {
    private static final MarshallingInfo<List> INPUTCHANNELLEVELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputChannelLevels").build();
    private static final MarshallingInfo<Integer> OUTPUTCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputChannel").build();
    private static final AudioChannelMappingMarshaller instance = new AudioChannelMappingMarshaller();

    public static AudioChannelMappingMarshaller getInstance() {
        return instance;
    }

    public void marshall(AudioChannelMapping audioChannelMapping, ProtocolMarshaller protocolMarshaller) {
        if (audioChannelMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(audioChannelMapping.getInputChannelLevels(), INPUTCHANNELLEVELS_BINDING);
            protocolMarshaller.marshall((Object)audioChannelMapping.getOutputChannel(), OUTPUTCHANNEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

