/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.HlsScte35SourceType;
import com.amazonaws.services.medialive.model.transform.HlsInputSettingsMarshaller;
import java.io.Serializable;

public class HlsInputSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer bandwidth;
    private Integer bufferSegments;
    private Integer retries;
    private Integer retryInterval;
    private String scte35Source;

    public void setBandwidth(Integer bandwidth) {
        this.bandwidth = bandwidth;
    }

    public Integer getBandwidth() {
        return this.bandwidth;
    }

    public HlsInputSettings withBandwidth(Integer bandwidth) {
        this.setBandwidth(bandwidth);
        return this;
    }

    public void setBufferSegments(Integer bufferSegments) {
        this.bufferSegments = bufferSegments;
    }

    public Integer getBufferSegments() {
        return this.bufferSegments;
    }

    public HlsInputSettings withBufferSegments(Integer bufferSegments) {
        this.setBufferSegments(bufferSegments);
        return this;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public HlsInputSettings withRetries(Integer retries) {
        this.setRetries(retries);
        return this;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public HlsInputSettings withRetryInterval(Integer retryInterval) {
        this.setRetryInterval(retryInterval);
        return this;
    }

    public void setScte35Source(String scte35Source) {
        this.scte35Source = scte35Source;
    }

    public String getScte35Source() {
        return this.scte35Source;
    }

    public HlsInputSettings withScte35Source(String scte35Source) {
        this.setScte35Source(scte35Source);
        return this;
    }

    public HlsInputSettings withScte35Source(HlsScte35SourceType scte35Source) {
        this.scte35Source = scte35Source.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBandwidth() != null) {
            sb.append("Bandwidth: ").append(this.getBandwidth()).append(",");
        }
        if (this.getBufferSegments() != null) {
            sb.append("BufferSegments: ").append(this.getBufferSegments()).append(",");
        }
        if (this.getRetries() != null) {
            sb.append("Retries: ").append(this.getRetries()).append(",");
        }
        if (this.getRetryInterval() != null) {
            sb.append("RetryInterval: ").append(this.getRetryInterval()).append(",");
        }
        if (this.getScte35Source() != null) {
            sb.append("Scte35Source: ").append(this.getScte35Source());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsInputSettings)) {
            return false;
        }
        HlsInputSettings other = (HlsInputSettings)obj;
        if (other.getBandwidth() == null ^ this.getBandwidth() == null) {
            return false;
        }
        if (other.getBandwidth() != null && !other.getBandwidth().equals(this.getBandwidth())) {
            return false;
        }
        if (other.getBufferSegments() == null ^ this.getBufferSegments() == null) {
            return false;
        }
        if (other.getBufferSegments() != null && !other.getBufferSegments().equals(this.getBufferSegments())) {
            return false;
        }
        if (other.getRetries() == null ^ this.getRetries() == null) {
            return false;
        }
        if (other.getRetries() != null && !other.getRetries().equals(this.getRetries())) {
            return false;
        }
        if (other.getRetryInterval() == null ^ this.getRetryInterval() == null) {
            return false;
        }
        if (other.getRetryInterval() != null && !other.getRetryInterval().equals(this.getRetryInterval())) {
            return false;
        }
        if (other.getScte35Source() == null ^ this.getScte35Source() == null) {
            return false;
        }
        return other.getScte35Source() == null || other.getScte35Source().equals(this.getScte35Source());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBandwidth() == null ? 0 : this.getBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.getBufferSegments() == null ? 0 : this.getBufferSegments().hashCode());
        hashCode = 31 * hashCode + (this.getRetries() == null ? 0 : this.getRetries().hashCode());
        hashCode = 31 * hashCode + (this.getRetryInterval() == null ? 0 : this.getRetryInterval().hashCode());
        hashCode = 31 * hashCode + (this.getScte35Source() == null ? 0 : this.getScte35Source().hashCode());
        return hashCode;
    }

    public HlsInputSettings clone() {
        try {
            return (HlsInputSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsInputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

