/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.medialive.model.Reservation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListReservationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Reservation> reservations;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListReservationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Reservation> getReservations() {
        return this.reservations;
    }

    public void setReservations(Collection<Reservation> reservations) {
        if (reservations == null) {
            this.reservations = null;
            return;
        }
        this.reservations = new ArrayList<Reservation>(reservations);
    }

    public ListReservationsResult withReservations(Reservation ... reservations) {
        if (this.reservations == null) {
            this.setReservations(new ArrayList<Reservation>(reservations.length));
        }
        for (Reservation ele : reservations) {
            this.reservations.add(ele);
        }
        return this;
    }

    public ListReservationsResult withReservations(Collection<Reservation> reservations) {
        this.setReservations(reservations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getReservations() != null) {
            sb.append("Reservations: ").append(this.getReservations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReservationsResult)) {
            return false;
        }
        ListReservationsResult other = (ListReservationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getReservations() == null ^ this.getReservations() == null) {
            return false;
        }
        return other.getReservations() == null || other.getReservations().equals(this.getReservations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getReservations() == null ? 0 : this.getReservations().hashCode());
        return hashCode;
    }

    public ListReservationsResult clone() {
        try {
            return (ListReservationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

