/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.AudioDolbyEDecode;
import com.amazonaws.services.medialive.model.AudioTrack;
import com.amazonaws.services.medialive.model.transform.AudioTrackSelectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AudioTrackSelection
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AudioTrack> tracks;
    private AudioDolbyEDecode dolbyEDecode;

    public List<AudioTrack> getTracks() {
        return this.tracks;
    }

    public void setTracks(Collection<AudioTrack> tracks) {
        if (tracks == null) {
            this.tracks = null;
            return;
        }
        this.tracks = new ArrayList<AudioTrack>(tracks);
    }

    public AudioTrackSelection withTracks(AudioTrack ... tracks) {
        if (this.tracks == null) {
            this.setTracks(new ArrayList<AudioTrack>(tracks.length));
        }
        for (AudioTrack ele : tracks) {
            this.tracks.add(ele);
        }
        return this;
    }

    public AudioTrackSelection withTracks(Collection<AudioTrack> tracks) {
        this.setTracks(tracks);
        return this;
    }

    public void setDolbyEDecode(AudioDolbyEDecode dolbyEDecode) {
        this.dolbyEDecode = dolbyEDecode;
    }

    public AudioDolbyEDecode getDolbyEDecode() {
        return this.dolbyEDecode;
    }

    public AudioTrackSelection withDolbyEDecode(AudioDolbyEDecode dolbyEDecode) {
        this.setDolbyEDecode(dolbyEDecode);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTracks() != null) {
            sb.append("Tracks: ").append(this.getTracks()).append(",");
        }
        if (this.getDolbyEDecode() != null) {
            sb.append("DolbyEDecode: ").append(this.getDolbyEDecode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioTrackSelection)) {
            return false;
        }
        AudioTrackSelection other = (AudioTrackSelection)obj;
        if (other.getTracks() == null ^ this.getTracks() == null) {
            return false;
        }
        if (other.getTracks() != null && !other.getTracks().equals(this.getTracks())) {
            return false;
        }
        if (other.getDolbyEDecode() == null ^ this.getDolbyEDecode() == null) {
            return false;
        }
        return other.getDolbyEDecode() == null || other.getDolbyEDecode().equals(this.getDolbyEDecode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTracks() == null ? 0 : this.getTracks().hashCode());
        hashCode = 31 * hashCode + (this.getDolbyEDecode() == null ? 0 : this.getDolbyEDecode().hashCode());
        return hashCode;
    }

    public AudioTrackSelection clone() {
        try {
            return (AudioTrackSelection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioTrackSelectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

