/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.WavSettings;

@SdkInternalApi
public class WavSettingsMarshaller {
    private static final MarshallingInfo<Double> BITDEPTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitDepth").build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").build();
    private static final MarshallingInfo<Double> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final WavSettingsMarshaller instance = new WavSettingsMarshaller();

    public static WavSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(WavSettings wavSettings, ProtocolMarshaller protocolMarshaller) {
        if (wavSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)wavSettings.getBitDepth(), BITDEPTH_BINDING);
            protocolMarshaller.marshall((Object)wavSettings.getCodingMode(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)wavSettings.getSampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

