/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.Job;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class JobMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACCELERATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accelerationSettings").build();
    private static final MarshallingInfo<String> ACCELERATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accelerationStatus").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> BILLINGTAGSSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingTagsSource").build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientRequestToken").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CURRENTPHASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentPhase").build();
    private static final MarshallingInfo<Integer> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorMessage").build();
    private static final MarshallingInfo<List> HOPDESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hopDestinations").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<Integer> JOBPERCENTCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobPercentComplete").build();
    private static final MarshallingInfo<String> JOBTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobTemplate").build();
    private static final MarshallingInfo<StructuredPojo> MESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messages").build();
    private static final MarshallingInfo<List> OUTPUTGROUPDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputGroupDetails").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("priority").build();
    private static final MarshallingInfo<String> QUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queue").build();
    private static final MarshallingInfo<List> QUEUETRANSITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("queueTransitions").build();
    private static final MarshallingInfo<Integer> RETRYCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryCount").build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("role").build();
    private static final MarshallingInfo<StructuredPojo> SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("settings").build();
    private static final MarshallingInfo<String> SIMULATERESERVEDQUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("simulateReservedQueue").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> STATUSUPDATEINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusUpdateInterval").build();
    private static final MarshallingInfo<StructuredPojo> TIMING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timing").build();
    private static final MarshallingInfo<Map> USERMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userMetadata").build();
    private static final MarshallingInfo<List> WARNINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("warnings").build();
    private static final JobMarshaller instance = new JobMarshaller();

    public static JobMarshaller getInstance() {
        return instance;
    }

    public void marshall(Job job, ProtocolMarshaller protocolMarshaller) {
        if (job == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)job.getAccelerationSettings(), ACCELERATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)job.getAccelerationStatus(), ACCELERATIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)job.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)job.getBillingTagsSource(), BILLINGTAGSSOURCE_BINDING);
            protocolMarshaller.marshall((Object)job.getClientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)job.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)job.getCurrentPhase(), CURRENTPHASE_BINDING);
            protocolMarshaller.marshall((Object)job.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)job.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(job.getHopDestinations(), HOPDESTINATIONS_BINDING);
            protocolMarshaller.marshall((Object)job.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)job.getJobPercentComplete(), JOBPERCENTCOMPLETE_BINDING);
            protocolMarshaller.marshall((Object)job.getJobTemplate(), JOBTEMPLATE_BINDING);
            protocolMarshaller.marshall((Object)job.getMessages(), MESSAGES_BINDING);
            protocolMarshaller.marshall(job.getOutputGroupDetails(), OUTPUTGROUPDETAILS_BINDING);
            protocolMarshaller.marshall((Object)job.getPriority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)job.getQueue(), QUEUE_BINDING);
            protocolMarshaller.marshall(job.getQueueTransitions(), QUEUETRANSITIONS_BINDING);
            protocolMarshaller.marshall((Object)job.getRetryCount(), RETRYCOUNT_BINDING);
            protocolMarshaller.marshall((Object)job.getRole(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)job.getSettings(), SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)job.getSimulateReservedQueue(), SIMULATERESERVEDQUEUE_BINDING);
            protocolMarshaller.marshall((Object)job.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)job.getStatusUpdateInterval(), STATUSUPDATEINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)job.getTiming(), TIMING_BINDING);
            protocolMarshaller.marshall(job.getUserMetadata(), USERMETADATA_BINDING);
            protocolMarshaller.marshall(job.getWarnings(), WARNINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

