/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.InputPolicy;
import com.amazonaws.services.mediaconvert.model.transform.PolicyMarshaller;
import java.io.Serializable;

public class Policy
implements Serializable,
Cloneable,
StructuredPojo {
    private String httpInputs;
    private String httpsInputs;
    private String s3Inputs;

    public void setHttpInputs(String httpInputs) {
        this.httpInputs = httpInputs;
    }

    public String getHttpInputs() {
        return this.httpInputs;
    }

    public Policy withHttpInputs(String httpInputs) {
        this.setHttpInputs(httpInputs);
        return this;
    }

    public Policy withHttpInputs(InputPolicy httpInputs) {
        this.httpInputs = httpInputs.toString();
        return this;
    }

    public void setHttpsInputs(String httpsInputs) {
        this.httpsInputs = httpsInputs;
    }

    public String getHttpsInputs() {
        return this.httpsInputs;
    }

    public Policy withHttpsInputs(String httpsInputs) {
        this.setHttpsInputs(httpsInputs);
        return this;
    }

    public Policy withHttpsInputs(InputPolicy httpsInputs) {
        this.httpsInputs = httpsInputs.toString();
        return this;
    }

    public void setS3Inputs(String s3Inputs) {
        this.s3Inputs = s3Inputs;
    }

    public String getS3Inputs() {
        return this.s3Inputs;
    }

    public Policy withS3Inputs(String s3Inputs) {
        this.setS3Inputs(s3Inputs);
        return this;
    }

    public Policy withS3Inputs(InputPolicy s3Inputs) {
        this.s3Inputs = s3Inputs.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHttpInputs() != null) {
            sb.append("HttpInputs: ").append(this.getHttpInputs()).append(",");
        }
        if (this.getHttpsInputs() != null) {
            sb.append("HttpsInputs: ").append(this.getHttpsInputs()).append(",");
        }
        if (this.getS3Inputs() != null) {
            sb.append("S3Inputs: ").append(this.getS3Inputs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        if (other.getHttpInputs() == null ^ this.getHttpInputs() == null) {
            return false;
        }
        if (other.getHttpInputs() != null && !other.getHttpInputs().equals(this.getHttpInputs())) {
            return false;
        }
        if (other.getHttpsInputs() == null ^ this.getHttpsInputs() == null) {
            return false;
        }
        if (other.getHttpsInputs() != null && !other.getHttpsInputs().equals(this.getHttpsInputs())) {
            return false;
        }
        if (other.getS3Inputs() == null ^ this.getS3Inputs() == null) {
            return false;
        }
        return other.getS3Inputs() == null || other.getS3Inputs().equals(this.getS3Inputs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHttpInputs() == null ? 0 : this.getHttpInputs().hashCode());
        hashCode = 31 * hashCode + (this.getHttpsInputs() == null ? 0 : this.getHttpsInputs().hashCode());
        hashCode = 31 * hashCode + (this.getS3Inputs() == null ? 0 : this.getS3Inputs().hashCode());
        return hashCode;
    }

    public Policy clone() {
        try {
            return (Policy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

