/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediaconnect.model.GatewayNetwork;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGatewayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> egressCidrBlocks;
    private String name;
    private List<GatewayNetwork> networks;

    public List<String> getEgressCidrBlocks() {
        return this.egressCidrBlocks;
    }

    public void setEgressCidrBlocks(Collection<String> egressCidrBlocks) {
        if (egressCidrBlocks == null) {
            this.egressCidrBlocks = null;
            return;
        }
        this.egressCidrBlocks = new ArrayList<String>(egressCidrBlocks);
    }

    public CreateGatewayRequest withEgressCidrBlocks(String ... egressCidrBlocks) {
        if (this.egressCidrBlocks == null) {
            this.setEgressCidrBlocks(new ArrayList<String>(egressCidrBlocks.length));
        }
        for (String ele : egressCidrBlocks) {
            this.egressCidrBlocks.add(ele);
        }
        return this;
    }

    public CreateGatewayRequest withEgressCidrBlocks(Collection<String> egressCidrBlocks) {
        this.setEgressCidrBlocks(egressCidrBlocks);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateGatewayRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<GatewayNetwork> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Collection<GatewayNetwork> networks) {
        if (networks == null) {
            this.networks = null;
            return;
        }
        this.networks = new ArrayList<GatewayNetwork>(networks);
    }

    public CreateGatewayRequest withNetworks(GatewayNetwork ... networks) {
        if (this.networks == null) {
            this.setNetworks(new ArrayList<GatewayNetwork>(networks.length));
        }
        for (GatewayNetwork ele : networks) {
            this.networks.add(ele);
        }
        return this;
    }

    public CreateGatewayRequest withNetworks(Collection<GatewayNetwork> networks) {
        this.setNetworks(networks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEgressCidrBlocks() != null) {
            sb.append("EgressCidrBlocks: ").append(this.getEgressCidrBlocks()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getNetworks() != null) {
            sb.append("Networks: ").append(this.getNetworks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayRequest)) {
            return false;
        }
        CreateGatewayRequest other = (CreateGatewayRequest)obj;
        if (other.getEgressCidrBlocks() == null ^ this.getEgressCidrBlocks() == null) {
            return false;
        }
        if (other.getEgressCidrBlocks() != null && !other.getEgressCidrBlocks().equals(this.getEgressCidrBlocks())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNetworks() == null ^ this.getNetworks() == null) {
            return false;
        }
        return other.getNetworks() == null || other.getNetworks().equals(this.getNetworks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEgressCidrBlocks() == null ? 0 : this.getEgressCidrBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNetworks() == null ? 0 : this.getNetworks().hashCode());
        return hashCode;
    }

    public CreateGatewayRequest clone() {
        return (CreateGatewayRequest)super.clone();
    }
}

