/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.MediaStreamAttributes;

@SdkInternalApi
public class MediaStreamAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> FMTP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fmtp").build();
    private static final MarshallingInfo<String> LANG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lang").build();
    private static final MediaStreamAttributesMarshaller instance = new MediaStreamAttributesMarshaller();

    public static MediaStreamAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaStreamAttributes mediaStreamAttributes, ProtocolMarshaller protocolMarshaller) {
        if (mediaStreamAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mediaStreamAttributes.getFmtp(), FMTP_BINDING);
            protocolMarshaller.marshall((Object)mediaStreamAttributes.getLang(), LANG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

