/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.Entitlement;
import com.amazonaws.services.mediaconnect.model.Output;
import com.amazonaws.services.mediaconnect.model.Source;
import com.amazonaws.services.mediaconnect.model.Status;
import com.amazonaws.services.mediaconnect.model.transform.FlowMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Flow
implements Serializable,
Cloneable,
StructuredPojo {
    private String availabilityZone;
    private String description;
    private String egressIp;
    private List<Entitlement> entitlements;
    private String flowArn;
    private String name;
    private List<Output> outputs;
    private Source source;
    private String status;

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Flow withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Flow withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEgressIp(String egressIp) {
        this.egressIp = egressIp;
    }

    public String getEgressIp() {
        return this.egressIp;
    }

    public Flow withEgressIp(String egressIp) {
        this.setEgressIp(egressIp);
        return this;
    }

    public List<Entitlement> getEntitlements() {
        return this.entitlements;
    }

    public void setEntitlements(Collection<Entitlement> entitlements) {
        if (entitlements == null) {
            this.entitlements = null;
            return;
        }
        this.entitlements = new ArrayList<Entitlement>(entitlements);
    }

    public Flow withEntitlements(Entitlement ... entitlements) {
        if (this.entitlements == null) {
            this.setEntitlements(new ArrayList<Entitlement>(entitlements.length));
        }
        for (Entitlement ele : entitlements) {
            this.entitlements.add(ele);
        }
        return this;
    }

    public Flow withEntitlements(Collection<Entitlement> entitlements) {
        this.setEntitlements(entitlements);
        return this;
    }

    public void setFlowArn(String flowArn) {
        this.flowArn = flowArn;
    }

    public String getFlowArn() {
        return this.flowArn;
    }

    public Flow withFlowArn(String flowArn) {
        this.setFlowArn(flowArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Flow withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<Output>(outputs);
    }

    public Flow withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public Flow withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public Flow withSource(Source source) {
        this.setSource(source);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Flow withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Flow withStatus(Status status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEgressIp() != null) {
            sb.append("EgressIp: ").append(this.getEgressIp()).append(",");
        }
        if (this.getEntitlements() != null) {
            sb.append("Entitlements: ").append(this.getEntitlements()).append(",");
        }
        if (this.getFlowArn() != null) {
            sb.append("FlowArn: ").append(this.getFlowArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)obj;
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEgressIp() == null ^ this.getEgressIp() == null) {
            return false;
        }
        if (other.getEgressIp() != null && !other.getEgressIp().equals(this.getEgressIp())) {
            return false;
        }
        if (other.getEntitlements() == null ^ this.getEntitlements() == null) {
            return false;
        }
        if (other.getEntitlements() != null && !other.getEntitlements().equals(this.getEntitlements())) {
            return false;
        }
        if (other.getFlowArn() == null ^ this.getFlowArn() == null) {
            return false;
        }
        if (other.getFlowArn() != null && !other.getFlowArn().equals(this.getFlowArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEgressIp() == null ? 0 : this.getEgressIp().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlements() == null ? 0 : this.getEntitlements().hashCode());
        hashCode = 31 * hashCode + (this.getFlowArn() == null ? 0 : this.getFlowArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public Flow clone() {
        try {
            return (Flow)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FlowMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

