/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mturk.model.PolicyParameter;
import com.amazonaws.services.mturk.model.transform.ReviewPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReviewPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyName;
    private List<PolicyParameter> parameters;

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public ReviewPolicy withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public List<PolicyParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<PolicyParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<PolicyParameter>(parameters);
    }

    public ReviewPolicy withParameters(PolicyParameter ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<PolicyParameter>(parameters.length));
        }
        for (PolicyParameter ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ReviewPolicy withParameters(Collection<PolicyParameter> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewPolicy)) {
            return false;
        }
        ReviewPolicy other = (ReviewPolicy)obj;
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ReviewPolicy clone() {
        try {
            return (ReviewPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReviewPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

