/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogAsync;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogAsyncClientBuilder;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogClient;
import com.amazonaws.services.marketplacecatalog.model.BatchDescribeEntitiesRequest;
import com.amazonaws.services.marketplacecatalog.model.BatchDescribeEntitiesResult;
import com.amazonaws.services.marketplacecatalog.model.CancelChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.CancelChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.DeleteResourcePolicyRequest;
import com.amazonaws.services.marketplacecatalog.model.DeleteResourcePolicyResult;
import com.amazonaws.services.marketplacecatalog.model.DescribeChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.DescribeChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.DescribeEntityRequest;
import com.amazonaws.services.marketplacecatalog.model.DescribeEntityResult;
import com.amazonaws.services.marketplacecatalog.model.GetResourcePolicyRequest;
import com.amazonaws.services.marketplacecatalog.model.GetResourcePolicyResult;
import com.amazonaws.services.marketplacecatalog.model.ListChangeSetsRequest;
import com.amazonaws.services.marketplacecatalog.model.ListChangeSetsResult;
import com.amazonaws.services.marketplacecatalog.model.ListEntitiesRequest;
import com.amazonaws.services.marketplacecatalog.model.ListEntitiesResult;
import com.amazonaws.services.marketplacecatalog.model.ListTagsForResourceRequest;
import com.amazonaws.services.marketplacecatalog.model.ListTagsForResourceResult;
import com.amazonaws.services.marketplacecatalog.model.PutResourcePolicyRequest;
import com.amazonaws.services.marketplacecatalog.model.PutResourcePolicyResult;
import com.amazonaws.services.marketplacecatalog.model.StartChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.StartChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.TagResourceRequest;
import com.amazonaws.services.marketplacecatalog.model.TagResourceResult;
import com.amazonaws.services.marketplacecatalog.model.UntagResourceRequest;
import com.amazonaws.services.marketplacecatalog.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMarketplaceCatalogAsyncClient
extends AWSMarketplaceCatalogClient
implements AWSMarketplaceCatalogAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMarketplaceCatalogAsyncClientBuilder asyncBuilder() {
        return AWSMarketplaceCatalogAsyncClientBuilder.standard();
    }

    AWSMarketplaceCatalogAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMarketplaceCatalogAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDescribeEntitiesResult> batchDescribeEntitiesAsync(BatchDescribeEntitiesRequest request) {
        return this.batchDescribeEntitiesAsync(request, null);
    }

    @Override
    public Future<BatchDescribeEntitiesResult> batchDescribeEntitiesAsync(BatchDescribeEntitiesRequest request, final AsyncHandler<BatchDescribeEntitiesRequest, BatchDescribeEntitiesResult> asyncHandler) {
        final BatchDescribeEntitiesRequest finalRequest = (BatchDescribeEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDescribeEntitiesResult>(){

            @Override
            public BatchDescribeEntitiesResult call() throws Exception {
                BatchDescribeEntitiesResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeBatchDescribeEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelChangeSetResult> cancelChangeSetAsync(CancelChangeSetRequest request) {
        return this.cancelChangeSetAsync(request, null);
    }

    @Override
    public Future<CancelChangeSetResult> cancelChangeSetAsync(CancelChangeSetRequest request, final AsyncHandler<CancelChangeSetRequest, CancelChangeSetResult> asyncHandler) {
        final CancelChangeSetRequest finalRequest = (CancelChangeSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelChangeSetResult>(){

            @Override
            public CancelChangeSetResult call() throws Exception {
                CancelChangeSetResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeCancelChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request) {
        return this.deleteResourcePolicyAsync(request, null);
    }

    @Override
    public Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request, final AsyncHandler<DeleteResourcePolicyRequest, DeleteResourcePolicyResult> asyncHandler) {
        final DeleteResourcePolicyRequest finalRequest = (DeleteResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteResourcePolicyResult>(){

            @Override
            public DeleteResourcePolicyResult call() throws Exception {
                DeleteResourcePolicyResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeDeleteResourcePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChangeSetResult> describeChangeSetAsync(DescribeChangeSetRequest request) {
        return this.describeChangeSetAsync(request, null);
    }

    @Override
    public Future<DescribeChangeSetResult> describeChangeSetAsync(DescribeChangeSetRequest request, final AsyncHandler<DescribeChangeSetRequest, DescribeChangeSetResult> asyncHandler) {
        final DescribeChangeSetRequest finalRequest = (DescribeChangeSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChangeSetResult>(){

            @Override
            public DescribeChangeSetResult call() throws Exception {
                DescribeChangeSetResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeDescribeChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEntityResult> describeEntityAsync(DescribeEntityRequest request) {
        return this.describeEntityAsync(request, null);
    }

    @Override
    public Future<DescribeEntityResult> describeEntityAsync(DescribeEntityRequest request, final AsyncHandler<DescribeEntityRequest, DescribeEntityResult> asyncHandler) {
        final DescribeEntityRequest finalRequest = (DescribeEntityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEntityResult>(){

            @Override
            public DescribeEntityResult call() throws Exception {
                DescribeEntityResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeDescribeEntity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request) {
        return this.getResourcePolicyAsync(request, null);
    }

    @Override
    public Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request, final AsyncHandler<GetResourcePolicyRequest, GetResourcePolicyResult> asyncHandler) {
        final GetResourcePolicyRequest finalRequest = (GetResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourcePolicyResult>(){

            @Override
            public GetResourcePolicyResult call() throws Exception {
                GetResourcePolicyResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeGetResourcePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChangeSetsResult> listChangeSetsAsync(ListChangeSetsRequest request) {
        return this.listChangeSetsAsync(request, null);
    }

    @Override
    public Future<ListChangeSetsResult> listChangeSetsAsync(ListChangeSetsRequest request, final AsyncHandler<ListChangeSetsRequest, ListChangeSetsResult> asyncHandler) {
        final ListChangeSetsRequest finalRequest = (ListChangeSetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChangeSetsResult>(){

            @Override
            public ListChangeSetsResult call() throws Exception {
                ListChangeSetsResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeListChangeSets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEntitiesResult> listEntitiesAsync(ListEntitiesRequest request) {
        return this.listEntitiesAsync(request, null);
    }

    @Override
    public Future<ListEntitiesResult> listEntitiesAsync(ListEntitiesRequest request, final AsyncHandler<ListEntitiesRequest, ListEntitiesResult> asyncHandler) {
        final ListEntitiesRequest finalRequest = (ListEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEntitiesResult>(){

            @Override
            public ListEntitiesResult call() throws Exception {
                ListEntitiesResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeListEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request) {
        return this.putResourcePolicyAsync(request, null);
    }

    @Override
    public Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request, final AsyncHandler<PutResourcePolicyRequest, PutResourcePolicyResult> asyncHandler) {
        final PutResourcePolicyRequest finalRequest = (PutResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutResourcePolicyResult>(){

            @Override
            public PutResourcePolicyResult call() throws Exception {
                PutResourcePolicyResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executePutResourcePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartChangeSetResult> startChangeSetAsync(StartChangeSetRequest request) {
        return this.startChangeSetAsync(request, null);
    }

    @Override
    public Future<StartChangeSetResult> startChangeSetAsync(StartChangeSetRequest request, final AsyncHandler<StartChangeSetRequest, StartChangeSetResult> asyncHandler) {
        final StartChangeSetRequest finalRequest = (StartChangeSetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartChangeSetResult>(){

            @Override
            public StartChangeSetResult call() throws Exception {
                StartChangeSetResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeStartChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMarketplaceCatalogAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

