/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceagreement;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.marketplaceagreement.AWSMarketplaceAgreementAsync;
import com.amazonaws.services.marketplaceagreement.AWSMarketplaceAgreementAsyncClientBuilder;
import com.amazonaws.services.marketplaceagreement.AWSMarketplaceAgreementClient;
import com.amazonaws.services.marketplaceagreement.model.DescribeAgreementRequest;
import com.amazonaws.services.marketplaceagreement.model.DescribeAgreementResult;
import com.amazonaws.services.marketplaceagreement.model.GetAgreementTermsRequest;
import com.amazonaws.services.marketplaceagreement.model.GetAgreementTermsResult;
import com.amazonaws.services.marketplaceagreement.model.SearchAgreementsRequest;
import com.amazonaws.services.marketplaceagreement.model.SearchAgreementsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMarketplaceAgreementAsyncClient
extends AWSMarketplaceAgreementClient
implements AWSMarketplaceAgreementAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMarketplaceAgreementAsyncClientBuilder asyncBuilder() {
        return AWSMarketplaceAgreementAsyncClientBuilder.standard();
    }

    AWSMarketplaceAgreementAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMarketplaceAgreementAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeAgreementResult> describeAgreementAsync(DescribeAgreementRequest request) {
        return this.describeAgreementAsync(request, null);
    }

    @Override
    public Future<DescribeAgreementResult> describeAgreementAsync(DescribeAgreementRequest request, final AsyncHandler<DescribeAgreementRequest, DescribeAgreementResult> asyncHandler) {
        final DescribeAgreementRequest finalRequest = (DescribeAgreementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAgreementResult>(){

            @Override
            public DescribeAgreementResult call() throws Exception {
                DescribeAgreementResult result = null;
                try {
                    result = AWSMarketplaceAgreementAsyncClient.this.executeDescribeAgreement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAgreementTermsResult> getAgreementTermsAsync(GetAgreementTermsRequest request) {
        return this.getAgreementTermsAsync(request, null);
    }

    @Override
    public Future<GetAgreementTermsResult> getAgreementTermsAsync(GetAgreementTermsRequest request, final AsyncHandler<GetAgreementTermsRequest, GetAgreementTermsResult> asyncHandler) {
        final GetAgreementTermsRequest finalRequest = (GetAgreementTermsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAgreementTermsResult>(){

            @Override
            public GetAgreementTermsResult call() throws Exception {
                GetAgreementTermsResult result = null;
                try {
                    result = AWSMarketplaceAgreementAsyncClient.this.executeGetAgreementTerms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchAgreementsResult> searchAgreementsAsync(SearchAgreementsRequest request) {
        return this.searchAgreementsAsync(request, null);
    }

    @Override
    public Future<SearchAgreementsResult> searchAgreementsAsync(SearchAgreementsRequest request, final AsyncHandler<SearchAgreementsRequest, SearchAgreementsResult> asyncHandler) {
        final SearchAgreementsRequest finalRequest = (SearchAgreementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchAgreementsResult>(){

            @Override
            public SearchAgreementsResult call() throws Exception {
                SearchAgreementsResult result = null;
                try {
                    result = AWSMarketplaceAgreementAsyncClient.this.executeSearchAgreements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

