/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.Role;
import com.amazonaws.services.managedgrafana.model.UpdateAction;
import com.amazonaws.services.managedgrafana.model.User;
import com.amazonaws.services.managedgrafana.model.transform.UpdateInstructionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateInstruction
implements Serializable,
Cloneable,
StructuredPojo {
    private String action;
    private String role;
    private List<User> users;

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public UpdateInstruction withAction(String action) {
        this.setAction(action);
        return this;
    }

    public UpdateInstruction withAction(UpdateAction action) {
        this.action = action.toString();
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public UpdateInstruction withRole(String role) {
        this.setRole(role);
        return this;
    }

    public UpdateInstruction withRole(Role role) {
        this.role = role.toString();
        return this;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(Collection<User> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        this.users = new ArrayList<User>(users);
    }

    public UpdateInstruction withUsers(User ... users) {
        if (this.users == null) {
            this.setUsers(new ArrayList<User>(users.length));
        }
        for (User ele : users) {
            this.users.add(ele);
        }
        return this;
    }

    public UpdateInstruction withUsers(Collection<User> users) {
        this.setUsers(users);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getUsers() != null) {
            sb.append("Users: ").append(this.getUsers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstruction)) {
            return false;
        }
        UpdateInstruction other = (UpdateInstruction)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        return other.getUsers() == null || other.getUsers().equals(this.getUsers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        return hashCode;
    }

    public UpdateInstruction clone() {
        try {
            return (UpdateInstruction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateInstructionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

